package com.bandyer.sdk_design.extensions

import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

/**
 * Retrieve recycler view's item position currently focused if any
 * @receiver RecyclerView
 * @return Int? the position under focus
 */
fun RecyclerView.findFocusedPosition(): Int? {
    val layoutManager = (layoutManager as? LinearLayoutManager) ?: (layoutManager as? GridLayoutManager) ?: return null
    return (layoutManager.findFirstVisibleItemPosition()..layoutManager.findLastVisibleItemPosition()).firstOrNull {
        layoutManager.findViewByPosition(it)?.isFocused == true
    }
}