/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.dialogs

import android.content.DialogInterface
import androidx.fragment.app.FragmentActivity
import com.bandyer.sdk_design.bottom_sheet.BandyerBottomSheetDialog

/**
 * Interface defining a bandyer dialog
 * @author kristiyan
 */
interface BandyerDialog<T : BandyerBottomSheetDialog> {

    /**
     * Identifier for the dialog
     */
    val id: String

    /**
     * If the dialog is visible or not
     */
    val isVisible
        get() = dialog?.isVisible == true

    /**
     * Dialog that will be handled
     */
    var dialog: T?

    /**
     * Call this method to show the dialog
     * @param activity Activity
     */
    fun show(activity: FragmentActivity)

    /**
     * Call this method to dismiss the dialog
     */
    fun dismiss() {
        if (dialog?.fragmentManager != null) dialog?.dismiss()
    }

    /**
     * Set a dismiss listener to be notified when the dialog has been dismissed
     * @param listener DialogInterface.OnDismissListener
     */
    fun setOnDismissListener(listener: DialogInterface.OnDismissListener) {
        dialog?.setDismissListener(listener)
    }

}