/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.extensions.StyleCompat
import kotlinx.android.synthetic.main.bandyer_widget_chat_unread_messages.view.*

/**
 * @suppress
 */
@Styleable("BandyerSDKDesign_Widget_ChatUnreadMessages")
class BandyerChatUnreadMessagesWidget @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int? = null)
    : LinearLayout(context, attrs, defStyleAttr ?: 0) {

    var callback: BandyerChatUnreadMessagesScrollDownClickedListener? = null

    var hasShown: Boolean = false

    @StyleableChild(R2.styleable.BandyerSDKDesign_Widget_ChatUnreadMessages_bandyer_unreadTextStyle)
    var unreadTexts: TextView? = null


    @StyleableChild(R2.styleable.BandyerSDKDesign_Widget_ChatUnreadMessages_bandyer_scrollDownIconStyle)
    var icon: ImageView? = null

    init {

        LayoutInflater.from(context).inflate(R.layout.bandyer_widget_chat_unread_messages, this)

        this.icon = icon_scroll_down
        this.unreadTexts = unread_text

        hideUnreadText()

        setOnClickListener {
            hide()
            callback?.onScrollDownClicked()
        }

        StyleCompat.style(this).builder().add(attrs).add(R.style.BandyerSDKDesign_Widget_ChatUnreadMessages).apply()
    }

    fun hideUnreadText() {
        unreadTexts?.visibility = GONE
        unreadTexts?.text = ""
    }

    fun show() {
        visibility = View.VISIBLE
        unreadTexts?.visibility = if (unreadTexts?.text!!.isEmpty()) View.GONE else View.VISIBLE
        hasShown = true
    }

    fun hide() {
        hideUnreadText()
        visibility = GONE
        hasShown = false
    }

    fun getUnreadText(): String {
        return unreadTexts?.text!!.toString()
    }

    fun setUnreadText(text: String) {
        if (text == "")
            hideUnreadText()
        else {
            unreadTexts?.text = text
            unreadTexts?.visibility = View.VISIBLE
        }
    }

    fun incrementUnreadMessages(count: Int) {
        val countMessages = (getUnreadText().toIntOrNull() ?: 0) + count
        setUnreadText(if (countMessages < 99) "$countMessages" else "99+")
        show()
    }

    fun incrementUnreadMessages() {
        val countMessages = (getUnreadText().toIntOrNull() ?: 0) + 1
        setUnreadText(if (countMessages < 99) "$countMessages" else "99+")
        show()
    }

    fun updatePosition(position: Int) {
        val current = unreadTexts?.text.toString().toIntOrNull() ?: 0

        if (position == 0)
            hide()
        else if (position < current) {
            val updatedText = "${current - 1}"
            if (updatedText != "0")
                setUnreadText(updatedText)
            else
                hideUnreadText()
        }
    }
}

/**
 * @suppress
 */
interface BandyerChatUnreadMessagesScrollDownClickedListener {
    fun onScrollDownClicked()
}