/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.layout

import android.content.Context
import android.util.AttributeSet
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.textviews.BandyerTextView
import com.bandyer.sdk_design.textviews.BandyerTextViewStyleApplier

/**
 * @suppress
 * @constructor
 */
class BandyerChatTimestampMessageLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : BandyerTextView(context, attrs, defStyleAttr) {

    override fun builderStyle(): BandyerTextViewStyleApplier.StyleBuilder {
        return super.builderStyle().add(R.style.BandyerSDKDesign_TextView_Chat_ChatMessageTimestamp)
    }

    /**
     * @suppress
     */
    override fun clearFocus() {
        if (parent != null) super.clearFocus()
    }
}