/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.layout

import android.content.Context
import androidx.annotation.StyleRes
import android.util.AttributeSet
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.extensions.StyleCompat
import com.bandyer.sdk_design.textviews.BandyerTextView

/**
 * Bandyer Chat TextMessage
 * @property messageTextView BandyerTextView?
 * @constructor
 */
@Styleable("BandyerSDKDesign_Chat_Layout_Message")
class BandyerChatTextMessageLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : BandyerBaseChatMessageLayout(context, attrs, defStyleAttr) {

    @StyleableChild(R2.styleable.BandyerSDKDesign_Chat_Layout_Message_bandyer_messageDataViewStyle)
    var messageTextView: BandyerTextView? = null
        private set

    init {
        dataView?.layoutResource = R.layout.bandyer_chat_message_text_data
        messageTextView = dataView?.inflate() as? BandyerTextView
    }

    /**
     * style the message Layout
     * @param style style to apply
     */
    fun style(@StyleRes style: Int) {
        StyleCompat.style(this).apply(style)
    }
}