/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.layout

import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.LinearLayout
import android.widget.ProgressBar
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.extensions.StyleCompat
import com.bandyer.sdk_design.textviews.BandyerTextView
import kotlinx.android.synthetic.main.bandyer_widget_chat_empty_state_item.view.*
import kotlinx.android.synthetic.main.bandyer_widget_chat_network_state_item.view.*

/**
 * Loader Layout for Chat
 * @suppress
 */
@Styleable("BandyerSDKDesign_Widget_ChatEmptyLoader")
class BandyerChatEmptyLoaderLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int? = null)
    : LinearLayout(context, attrs, defStyleAttr ?: 0) {

    @StyleableChild(R2.styleable.BandyerSDKDesign_Widget_ChatEmptyLoader_bandyer_loadingTextStyle)
    var text: BandyerTextView? = null

    init {
        LayoutInflater.from(context).inflate(R.layout.bandyer_widget_chat_empty_state_item, this, true)
        this.text = loading
        StyleCompat.style(this).apply(R.style.BandyerSDKDesign_Widget_ChatEmptyLoader)
    }

    /**
     * @suppress
     */
    override fun clearFocus() {
        if (parent != null) super.clearFocus()
    }
}