/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.layout

import android.content.Context
import androidx.constraintlayout.widget.ConstraintLayout
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.ViewStub
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.chat.imageviews.BandyerChatMessageStatusImageView
import com.bandyer.sdk_design.textviews.BandyerTextView

/**
 * Base Chat Message Layout
 * @constructor
 */
@Styleable("BandyerSDKDesign_Chat_Layout_Message")
abstract class BandyerBaseChatMessageLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : androidx.constraintlayout.widget.ConstraintLayout(context, attrs, defStyleAttr) {

    /**
     * TimeStamp view that displays when the message has been sent
     */
    @StyleableChild(R2.styleable.BandyerSDKDesign_Chat_Layout_Message_bandyer_messageTimestampTextViewStyle)
    var timestampTextView: BandyerTextView? = null
        private set

    /**
     * Message Status view which represents if a message is pending, sent or seen
     */
    @StyleableChild(R2.styleable.BandyerSDKDesign_Chat_Layout_Message_bandyer_messageStatusImageViewStyle)
    var statusView: BandyerChatMessageStatusImageView? = null
        private set

    /**
     * Container of the dataView
     */
    @StyleableChild(R2.styleable.BandyerSDKDesign_Chat_Layout_Message_bandyer_messageDataViewContainerStyle)
    var dataViewContainer: View? = null
        private set
    /**
     * View containing the data of the message for example imageView, textView or other types of layout may be used
     */
    protected var dataView: ViewStub? = null
        private set

    init {
        LayoutInflater.from(context).inflate(com.bandyer.sdk_design.R.layout.bandyer_chat_message_base, this, true)
        this.id = com.bandyer.sdk_design.R.id.bandyer_id_chat_base_message_layout
        this.layoutParams = ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)

        dataViewContainer = findViewById(R.id.dataViewContainer)
        statusView = findViewById(R.id.statusView)
        timestampTextView = findViewById(R.id.timestampView)
        dataView = findViewById(R.id.dataView)
    }

    /**
     * Display status
     * @param show true to display, false otherwise
     */
    fun showStatus(show: Boolean) {
        statusView?.visibility = if (show) View.VISIBLE else View.GONE
    }


    /**
     * @suppress
     */
    override fun clearFocus() {
        if (parent != null) super.clearFocus()
    }
}
