/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.imageviews

import android.content.Context
import android.graphics.drawable.Drawable
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatImageView
import com.airbnb.paris.annotations.Attr
import com.airbnb.paris.annotations.Styleable
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.imageviews.BandyerRoundedImageView

/**
 * Bandyer Chat MessageStatus ImageView used to display an image representing a pending, sent or seen message
 * @author kristiyan
 */
@Styleable("BandyerSDKDesign_Chat_ImageView_Message_Status")
class BandyerChatMessageStatusImageView @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : AppCompatImageView(context, attrs, defStyleAttr) {

    private var pendingImageDrawable: Drawable? = null
    private var sentImageDrawable: Drawable? = null
    private var seenImageDrawable: Drawable? = null

    /**
     * Set the drawable to use as pending status indicator
     * @param drawable pending drawable indicator
     */
    @Attr(R2.styleable.BandyerSDKDesign_Chat_ImageView_Message_Status_bandyer_pendingMessageImage)
    fun setPendingImage(drawable: Drawable) {
        pendingImageDrawable = drawable
    }

    /**
     * Set the drawable to use as sent status indicator
     * @param drawable sent drawable indicator
     */
    @Attr(R2.styleable.BandyerSDKDesign_Chat_ImageView_Message_Status_bandyer_sentMessageImage)
    fun setSentImage(drawable: Drawable) {
        sentImageDrawable = drawable
    }

    /**
     * Set the drawable to use as seen status indicator
     * @param drawable seen drawable indicator
     */
    @Attr(R2.styleable.BandyerSDKDesign_Chat_ImageView_Message_Status_bandyer_seenMessageImage)
    fun setSeenImage(drawable: Drawable) {
        seenImageDrawable = drawable
    }

    /**
     * Apply the pending layout
     */
    fun setAsPending() {
        setImageDrawable(pendingImageDrawable)
    }

    /**
     * Apply the seen layout
     */
    fun setAsSeen() {
        setImageDrawable(seenImageDrawable)
    }

    /**
     * Apply the sent layout
     */
    fun setAsSent() {
        setImageDrawable(sentImageDrawable)
    }
}