/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.adapter_items.message.text

import android.view.View
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.chat.adapter_items.message.abstract_message.BandyerBaseChatMessageViewHolder
import com.bandyer.sdk_design.chat.layout.BandyerChatTextMessageLayout
import com.bandyer.sdk_design.extensions.StyleCompat

/**
 * Bandyer Chat TextMessage ViewHolder
 * @constructor
 */
class BandyerChatTextMessageViewHolder(view: View) : BandyerBaseChatMessageViewHolder<BandyerChatTextMessageLayout, BandyerChatTextMessageItem>(view) {

    /**
     * @suppress
     */
    override fun bind(item: BandyerChatTextMessageItem, itemView: BandyerChatTextMessageLayout, payloads: MutableList<Any>) {
        itemView.messageTextView?.text = item.data.message
    }

    /**
     * @suppress
     */
    override fun style(item: BandyerChatTextMessageItem, itemView: BandyerChatTextMessageLayout) {
        val style = item.data.style ?: if (item.data.mine)
            R.style.BandyerSDKDesign_Chat_Layout_Message_Text_LoggedUser
        else
            R.style.BandyerSDKDesign_Chat_Layout_Message_Text_OtherUser
        StyleCompat.style(itemView).apply(style)
    }

    /**
     * @suppress
     */
    override fun unbind(item: BandyerChatTextMessageItem, itemView: BandyerChatTextMessageLayout) {

    }
}