/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.adapter_items.message.text

import android.view.View
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.chat.adapter_items.message.abstract_message.BandyerBaseChatMessageItem

/**
 * Bandyer Chat TextMessage Item
 * @param chatTextMessage TextView for the message
 * @constructor
 * @author kristiyan
 */
class BandyerChatTextMessageItem(val chatTextMessage: BandyerChatTextMessage) : BandyerBaseChatMessageItem<BandyerChatTextMessage>(chatTextMessage) {

    /**
     * @suppress
     */
    override fun getViewHolder(v: View) = BandyerChatTextMessageViewHolder(v)

    /**
     * @suppress
     */
    override fun getLayoutRes(): Int = R.layout.bandyer_chat_message_text
}
