/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.adapter_items.message.text

import com.bandyer.sdk_design.chat.adapter_items.message.abstract_message.BandyerBaseChatMessage

/**
 * Bandyer Chat Text Message
 * @property message String message
 * @constructor
 */
data class BandyerChatTextMessage(var message: String,
                                  override var timestamp: Long,
                                  override var mine: Boolean,
                                  override var pending: Boolean,
                                  override var sent: Boolean,
                                  override val seen: () -> Boolean) : BandyerBaseChatMessage {

    override var style: Int? = null
}