/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.chat.adapter_items.message.abstract_message

/**
 * Base Model for a Chat Message
 * @property style message style to apply
 * @property mine true if the message is mine, false otherwise
 * @property timestamp timestamp of the message
 * @property pending true if the message is still pending, false otherwise
 * @property sent true if the message has been sent, false otherwise
 * @property seen Function0<Boolean> return true if has been seen, false otherwise
 */
interface BandyerBaseChatMessage {
    val style: Int?
    val mine: Boolean
    val timestamp: Long
    val pending: Boolean
    val sent: Boolean
    val seen: () -> Boolean
}