/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.call.layout

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.RelativeLayout
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.buttons.BandyerImageButton
import com.bandyer.sdk_design.extensions.StyleCompat
import com.bandyer.sdk_design.textviews.BandyerTextView
import kotlinx.android.synthetic.main.bandyer_snapshot_dialog_layout.view.*

/**
 * @suppress
 */
@Styleable("BandyerSDK_DialogStyle_SnapshotPreview_Layout")
class BandyerSnapshotDialogLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : RelativeLayout(context, attrs, defStyleAttr) {

    @StyleableChild(R2.styleable.BandyerSDK_DialogStyle_SnapshotPreview_Layout_bandyer_closeButtonStyle)
    var closeButton: BandyerImageButton? = null
        private set
    @StyleableChild(R2.styleable.BandyerSDK_DialogStyle_SnapshotPreview_Layout_bandyer_saveImageButtonStyle)
    var saveButton: BandyerImageButton? = null
        private set
    @StyleableChild(R2.styleable.BandyerSDK_DialogStyle_SnapshotPreview_Layout_bandyer_collaborateButtonStyle)
    var collaborateButton: BandyerTextView? = null
        private set

    init {
        LayoutInflater.from(context).inflate(R.layout.bandyer_snapshot_dialog_layout, this)
        closeButton = bandyer_snapshot_share_close_button
        saveButton = bandyer_snapshot_share_save_button
        collaborateButton = bandyer_snapshot_share_whiteboard_button
        StyleCompat.styleBuilder(this)
                .add(attrs)
                .add(R.style.BandyerSDK_DialogStyle_SnapshotPreview_Layout)
                .apply()

    }
}