package com.bandyer.sdk_design.call.layout

import android.content.Context
import android.net.Uri
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.LinearLayout
import androidx.appcompat.widget.AppCompatImageView
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.extensions.StyleCompat
import com.bandyer.sdk_design.textviews.BandyerTextViewTitle
import com.bandyer.sdk_design.utils.bandyerSDKDesignPrefs
import com.squareup.picasso.Picasso
import kotlinx.android.synthetic.main.bandyer_call_watermark.view.*
import java.io.File


/**
 * Bandyer watermark layout
 * @author kristiyan
 * @constructor
 */
@Styleable("BandyerSDKDesign_Call_Layout_Watermark")
class BandyerCallWatermarkLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : LinearLayout(context, attrs, defStyleAttr) {

    /**
     * Image of the watermark
     */
    @StyleableChild(R2.styleable.BandyerSDKDesign_Call_Layout_Watermark_bandyer_imageViewStyle)
    var watermarkImage: AppCompatImageView? = null
        private set

    /**
     * Title of the watermark
     */
    @StyleableChild(R2.styleable.BandyerSDKDesign_Call_Layout_Watermark_bandyer_textViewStyle)
    var watermarkText: BandyerTextViewTitle? = null
        private set

    init {
        LayoutInflater.from(context).inflate(R.layout.bandyer_call_watermark, this, true)
        watermarkImage = pref_image_view
        watermarkText = pref_text_view

        StyleCompat.styleBuilder(this)
                .add(attrs)
                .add(R.style.BandyerSDKDesign_Call_Layout_Watermark)
                .apply()

        val watermarkLogo = bandyerSDKDesignPrefs().getString("call_watermark_image_uri", null)
        val watermarkTitle = bandyerSDKDesignPrefs().getString("call_watermark_text", null)

        post { setUp(watermarkLogo, watermarkTitle) }
    }


    private fun setUp(watermarkLogo: String?, watermarkTitle: String?) {
        watermarkTitle?.let {
            pref_image_view.visibility = if (it.isBlank()) View.GONE else View.VISIBLE
            pref_text_view.text = it
            pref_text_view.requestLayout()
        }

        watermarkLogo?.let {
            val uri = if (watermarkLogo.startsWith("content") || watermarkLogo.startsWith("android.resource") || watermarkLogo.startsWith("file") || watermarkLogo.startsWith("http")) Uri.parse(watermarkLogo) else Uri.fromFile(File(watermarkLogo))
            Picasso.get().load(uri).into(pref_image_view)
            pref_image_view.visibility = if (it.isBlank()) View.GONE else View.VISIBLE
            pref_image_view.requestLayout()

        }
    }
}
