/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.call.imageviews

import android.content.Context
import android.util.AttributeSet
import com.airbnb.paris.annotations.Style
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.extensions.StyleCompat
import com.bandyer.sdk_design.imageviews.BandyerRoundedImageView

/**
 * Bandyer avatar image view
 * @property type if single user or multiple placeholder
 * @constructor
 */
class BandyerAvatarImageView @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : BandyerRoundedImageView(context, attrs, defStyleAttr) {

    /**
     * BandyerAvatarImageView instance
     */
    companion object {

        /**
         * Single user style
         */
        @Style
        val USER = R.style.BandyerSDKDesign_ImageViews_Avatars_User

        /**
         * Multiple users style
         */
        @Style
        val MULTIPLE_USERS = R.style.BandyerSDKDesign_ImageViews_Avatars_User

    }

    var type: AvatarType = AvatarType.USER
        set(value) {
            field = value
            when (value) {
                AvatarType.USER -> {
                    StyleCompat
                            .style(this)
                            .apply(R.style.BandyerSDKDesign_ImageViews_Avatars_User)
                }
                AvatarType.MULTIPLE_USERS -> {
                    StyleCompat
                            .style(this)
                            .apply(R.style.BandyerSDKDesign_ImageViews_Avatars_MultipleUsers)
                }
            }
            round<BandyerAvatarImageView>(true)
        }

}

/**
 * Enum representing avatar type
 */
enum class AvatarType {
    /**
     * single user
     */
    USER,
    /**
     * multiple users
     */
    MULTIPLE_USERS
}