/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.call.buttons.action

import android.content.Context
import android.util.AttributeSet

import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.buttons.action.BandyerActionButton
import com.bandyer.sdk_design.extensions.StyleCompat

/**
 * This class represents a button used in Bandyer SDK to switch camera during a video/audio call.
 * This button can be styled overriding 'BandyerSDKDesign.Button.Borderless.SwitchCameraStyle' style.
 */
class BandyerActionButtonSwitchCamera @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int? = null)
    : BandyerActionButton(context, attrs, defStyleAttr) {

    init {
        StyleCompat.style(this).apply(R.style.BandyerSDKDesign_ActionButton_SwitchCamera)
        button?.tag = BOTTOM_SHEET_TAG
    }
}