/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.call.buttons.action

import android.content.Context
import android.util.AttributeSet

import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.buttons.action.BandyerActionButton
import com.bandyer.sdk_design.extensions.StyleCompat

/**
 * This class represents a button used in Bandyer SDK to change audio settings.
 * This button can be styled overriding 'BandyerSDKDesign.Button.Borderless.AudioRouteStyle' style.
 */
class BandyerActionButtonAudioRoute @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int? = null) : BandyerActionButton(context, attrs, defStyleAttr) {

    init {
        StyleCompat.style(this).apply(R.style.BandyerSDKDesign_ActionButton_AudioRoute)
        button?.tag = BOTTOM_SHEET_TAG
    }

    /**
     * Displays bluetooth icon as declared in 'BandyerSDKDesign.Button.Borderless.AudioRouteStyle' style
     */
    fun setBluetoothIcon() {
        StyleCompat.style(button).apply(R.style.BandyerSDKDesign_ImageButton_Bluetooth)
    }

    /**
     * Displays wired headset icon as declared in 'BandyerSDKDesign.Button.Borderless.AudioRouteStyle' style
     */
    fun setWiredHeadsetIcon() {
        StyleCompat.style(button).apply(R.style.BandyerSDKDesign_ImageButton_Headset)
    }

    /**
     * Displays loudspeaker icon as declared in 'BandyerSDKDesign.Button.Borderless.AudioRouteStyle' style
     */
    fun setLoudSpeakerIcon() {
        StyleCompat.style(button).apply(R.style.BandyerSDKDesign_ImageButton_LoudSpeaker)
    }

    /**
     * Displays ic_bandyer_earpiece icon as declared in 'BandyerSDKDesign.Button.Borderless.AudioRouteStyle' style
     */
    fun setEarpieceIcon() {
        StyleCompat.style(button).apply(R.style.BandyerSDKDesign_ImageButton_Earpiece)
    }

    /**
     * Displays mute icon as declared in 'BandyerSDKDesign.Button.Borderless.AudioRouteStyle' style
     */
    fun setMutedIcon() {
        StyleCompat.style(button).apply(R.style.BandyerSDKDesign_ImageButton_AudioOff)
    }
}
