/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.call.bottom_sheet

import androidx.appcompat.app.AppCompatActivity
import com.bandyer.sdk_design.bottom_sheet.BandyerClickableBottomSheet
import com.bandyer.sdk_design.bottom_sheet.items.ActionItem
import com.bandyer.sdk_design.bottom_sheet.view.BottomSheetLayoutType
import com.bandyer.sdk_design.call.bottom_sheet.items.CallAction

/**
 *
 * @author kristiyan
 */

@Suppress("UNCHECKED_CAST")
open class RingingBottomSheet<T>(context: AppCompatActivity, bottomSheetStyle: Int) : BandyerClickableBottomSheet<T>(
        context,
        CallAction.getIncomingCallActions() as List<T>,
        2,
        0,
        BottomSheetLayoutType.GRID,
        bottomSheetStyle) where T : ActionItem {

    override fun show() {
        super.show()
        bottomSheetBehavior!!.isHideable = false
        bottomSheetBehavior!!.skipCollapsed = true
        bottomSheetBehavior!!.disableDragging = true
        expand()
    }
}