/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.buttons.floating

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup.LayoutParams.WRAP_CONTENT
import android.widget.LinearLayout
import com.bandyer.sdk_design.R

/**
 * Abstract Bandyer Floating Button
 * @author kristiyan
 */
abstract class BandyerFloatingButton @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : LinearLayout(context, attrs, defStyleAttr) {

    init {
        layoutParams = LayoutParams(WRAP_CONTENT, WRAP_CONTENT)
        View.inflate(context, this.getLayoutRes(), this)
    }

    /**
     * Get the Floating Button layout to inflate
     * @return floating button layout
     */
    abstract fun getLayoutRes(): Int

    /**
     * @suppress
     */
    override fun setOnClickListener(l: OnClickListener?) {
        if (!setClickListenerOnChildren) {
            super.setOnClickListener(l)
            return
        }
        findViewById<View>(R.id.buttonView).setOnClickListener(l)
    }

    /**
     * By default only the children will listen for click events
     */
    var setClickListenerOnChildren = true
}