/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.buttons.action

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.airbnb.paris.annotations.Attr
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.buttons.BandyerImageButton
import com.bandyer.sdk_design.extensions.StyleCompat
import com.bandyer.sdk_design.textviews.BandyerTextView
import kotlinx.android.synthetic.main.bandyer_action_button.view.*

/**
 * Bandyer Action Button which is a composite of a button and a textView
 * @author kristiyan
 */
@Styleable("BandyerSDKDesign_ActionButton")
open class BandyerActionButton @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int? = null)
    : LinearLayout(context, attrs, defStyleAttr ?: 0) {

    /**
     * BandyerAction Button companion object.
     */
    companion object {
        /**
         * Constant representing if the action button will be a child of a bottom sheet
         */
        const val BOTTOM_SHEET_TAG = "bottom_sheet"
    }

    /**
     * Base Button component
     */
    @StyleableChild(R2.styleable.BandyerSDKDesign_ActionButton_bandyer_buttonStyle)
    var button: BandyerImageButton? = null

    /**
     * Base Label component
     */
    @StyleableChild(R2.styleable.BandyerSDKDesign_ActionButton_bandyer_labelStyle)
    var label: BandyerTextView? = null


    /**
     * Set custom action button orientation
     * @param orientation requested orientation
     */
    @Attr(R2.styleable.BandyerSDKDesign_ActionButton_bandyer_customOrientation)
    fun setCustomOrientation(orientation: Int) {
        setOrientation(if (orientation == 0) HORIZONTAL else if (orientation == 1) VERTICAL else HORIZONTAL)
    }

    init {
        View.inflate(context, this.getLayout(), this)

        button = buttonView!!
        label = labelView!!

        StyleCompat.style(this).apply(R.style.BandyerSDKDesign_ActionButton)
    }

    /**
     * Base Layout to inflate
     * @return layout that will be used
     */
    open fun getLayout(): Int = R.layout.bandyer_action_button

    /**
     * @suppress
     */
    override fun setOnClickListener(l: OnClickListener?) {
        if (!setClickListenerOnChildren) {
            super.setOnClickListener(l)
            return
        }
        if (!label!!.hasOnClickListeners()) label!!.setOnClickListener(l)
        if (!button!!.hasOnClickListeners()) button!!.setOnClickListener(l)
    }

    /**
     * By default only the children will listen for click events
     */
    var setClickListenerOnChildren = true
}