/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.bottom_sheet.view

import android.annotation.SuppressLint
import android.content.Context
import android.util.AttributeSet

/**
 * A custom Coordinator Layout
 * @author kristiyan
 */
open class BandyerBottomSheetLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : androidx.coordinatorlayout.widget.CoordinatorLayout(context, attrs, defStyleAttr) {

    /**
     *@suppress
     */
    @SuppressLint("WrongViewCast")
    override fun setVisibility(visibility: Int) {
        super.setVisibility(visibility)
        for (i in 0..childCount) {
            val layout = getChildAt(i) as? BottomSheetLayoutContent
            layout?.backgroundView?.visibility = visibility
        }
    }
}