/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.bottom_sheet.items

import android.view.View
import com.mikepenz.fastadapter.FastAdapter
import com.mikepenz.fastadapter.items.AbstractItem

/**
 * View holder for the action items
 * @suppress
 */
class ActionItemViewHolder(var item: ActionItem) : AbstractItem<ActionItemViewHolder, ActionItemViewHolder.Holder>() {

    override fun getViewHolder(v: View): Holder {
        return Holder(v)
    }

    override fun getType(): Int {
        return item.javaClass.name.hashCode()
    }

    override fun getLayoutRes(): Int {
        return item.viewLayoutRes
    }

    class Holder internal constructor(view: View) : FastAdapter.ViewHolder<ActionItemViewHolder>(view) {

        override fun bindView(listItem: ActionItemViewHolder, payloads: List<Any>) {
            listItem.item.itemView = itemView
            listItem.item.onReady()
        }

        override fun unbindView(item: ActionItemViewHolder) {
            item.item.itemView = null
        }
    }
}