/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.bottom_sheet.behaviours

import android.content.Context
import android.util.AttributeSet
import android.view.MotionEvent
import android.view.View
import androidx.coordinatorlayout.widget.CoordinatorLayout
import com.google.android.material.bottomsheet.BottomSheetBehavior

/**
 * Bottom sheet dialog behaviour which allows to disable dragging
 * @param V : View to attach the behaviour
 * @property disableDragging Boolean true to disable dragging
 */
class BandyerBottomSheetDialogBehaviour<V : View> : BottomSheetBehavior<V> {

    var disableDragging = false

    /**
     * @suppress
     */
    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)

    /**
     * @suppress
     */
    @Suppress("unused")
    constructor() : super()


    /**
     * @suppress
     */
    override fun onInterceptTouchEvent(parent: CoordinatorLayout, child: V, event: MotionEvent): Boolean {
        if (disableDragging) return false
        return super.onInterceptTouchEvent(parent, child, event)
    }

    /**
     * @suppress
     */
    override fun onTouchEvent(parent: CoordinatorLayout, child: V, event: MotionEvent): Boolean {
        if (disableDragging) return false
        return super.onTouchEvent(parent, child, event)
    }

    /**
     * @suppress
     */
    override fun onNestedPreFling(coordinatorLayout: CoordinatorLayout, child: V, target: View, velocityX: Float, velocityY: Float): Boolean {
        return false
    }

    /**
     * @suppress
     */
    override fun onNestedPreScroll(coordinatorLayout: CoordinatorLayout, child: V, target: View, dx: Int, dy: Int, consumed: IntArray, type: Int) {
        return
    }
}