/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.bottom_sheet

/**
 * Listener of the status changes of the BottomSheet
 * @param T : BandyerBottomSheet
 */
interface OnStateChangedBottomSheetListener<T : BandyerBottomSheet> {

    /**
     * When the bottomSheet has been shown
     * @param bottomSheet T
     */
    fun onShow(bottomSheet: T)

    /**
     * When the bottomSheet has been hidden
     * @param bottomSheet T
     */
    fun onHide(bottomSheet: T)

    /**
     * When the bottomSheet has been collapsed
     * @param bottomSheet T
     */
    fun onCollapse(bottomSheet: T)

    /**
     * When the bottomSheet is being been dragged
     * @param bottomSheet T
     */
    fun onDragging(bottomSheet: T)

    /**
     * When the bottomSheet has been expanded
     * @param bottomSheet T
     */
    fun onExpand(bottomSheet: T)

    /**
     * When the bottomSheet has been anchored
     * @param bottomSheet T
     */
    fun onAnchor(bottomSheet: T)

    /**
     * When the bottomSheet is sliding
     * @param bottomSheet T
     */
    fun onSlide(bottomSheet: T, slideOffset: Float)
}