/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.bottom_sheet

import android.view.View
import androidx.annotation.StyleRes
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.RecyclerView
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.bottom_sheet.items.ActionItem
import com.bandyer.sdk_design.bottom_sheet.items.ActionItemViewHolder
import com.bandyer.sdk_design.bottom_sheet.view.BottomSheetLayoutType
import com.mikepenz.fastadapter.FastAdapter
import com.mikepenz.fastadapter.listeners.ClickEventHook

/**
 * This class represents a bottom sheet displaying clickable items.
 * @author kristiyan
 */
@Suppress("UNCHECKED_CAST")
open class BandyerClickableBottomSheet<T> constructor(context: AppCompatActivity,
                                                      views: List<T>,
                                                      spanSize: Int,
                                                      peekHeight: Int?,
                                                      bottomSheetLayoutType: BottomSheetLayoutType,
                                                      @StyleRes bottomSheetLayoutStyle: Int) : BandyerActionBottomSheet<T>(context, views, spanSize, peekHeight, bottomSheetLayoutType, bottomSheetLayoutStyle) where T : ActionItem {

    init {
        fastAdapter.withEventHook(object : ClickEventHook<ActionItemViewHolder>() {
            override fun onClick(v: View, position: Int, fastAdapter: FastAdapter<ActionItemViewHolder>, item: ActionItemViewHolder) {
                if (item.item.itemView == null) return
                val listener = onActionBottomSheetListener as? OnActionBottomSheetListener<ActionItem, BandyerBottomSheet>
                listener?.onActionClicked(this@BandyerClickableBottomSheet, item.item as T, position)
            }

            override fun onBindMany(viewHolder: RecyclerView.ViewHolder): MutableList<View> {
                val listOfViews = mutableListOf<View>()
                viewHolder.itemView.findViewById<View?>(R.id.buttonView)?.let { listOfViews.add(it) }
                viewHolder.itemView.findViewById<View?>(R.id.labelView)?.let { listOfViews.add(it) }
                return listOfViews
            }
        })
    }
}