/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.bottom_sheet

import androidx.annotation.StyleRes
import androidx.appcompat.app.AppCompatActivity
import com.bandyer.sdk_design.bottom_sheet.items.ActionItem
import com.bandyer.sdk_design.bottom_sheet.view.BottomSheetLayoutType

/**
 * A Bandyer BottomSheet specialized in handling actions
 * @author kristiyan
 */
open class BandyerActionBottomSheet<T> constructor(context: AppCompatActivity,
                                                   views: List<T>,
                                                   spanSize: Int,
                                                   peekHeight: Int?,
                                                   bottomSheetLayoutType: BottomSheetLayoutType,
                                                   @StyleRes bottomSheetLayoutStyle: Int) : BaseBandyerBottomSheet(context, views, spanSize, peekHeight, bottomSheetLayoutType, bottomSheetLayoutStyle) where T : ActionItem {

    /**
     * Listener for actions on the items of the bottomSheet
     */
    var onActionBottomSheetListener: BandyerActionBottomSheet.OnActionBottomSheetListener<*, *>? = null

    /**
     * Generic interface handling action events
     * @param T ActionItem where the event has been fired from
     * @param F BottomSheet enclosing the actions
     */
    interface OnActionBottomSheetListener<T, F> where T : ActionItem, F : BandyerBottomSheet {
        /**
         * Called when an action has received a click event
         * @param bottomSheet F bottomSheet container
         * @param action T action clicked
         * @param position Int position of item in the bottomSheet
         * @return true if handled false otherwise
         */
        fun onActionClicked(bottomSheet: F, action: T, position: Int): Boolean
    }
}