/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.tsdb.utils.QuotaCalculator;
import com.baidubce.util.Validate;
import lombok.NonNull;

public class ResizeDatabaseRequest
extends AbstractBceRequest {
    @NonNull
    private String databaseId;
    private long ingestDataPointsMonthly;
    private long queryUnitsMonthly;
    private long storeBytesQuota;
    private long timeSeriesQuota;
    private int lengthLimitMultipleQuota;
    private String couponName;

    public ResizeDatabaseRequest(String databaseId, long ingestDataPointsMonthly, long queryUnitsMonthly, long storeBytesQuota, long timeSeriesQuota, int lengthLimitMultipleQuota, String couponName) {
        Validate.checkIsTrue(ingestDataPointsMonthly > 0L && ingestDataPointsMonthly % 1000000L == 0L, "Illegal quota of ingest, must be greater than 0 and be multiple of INGEST_QUOTA_UNIT(1 million).");
        Validate.checkIsTrue(queryUnitsMonthly >= 100000L && queryUnitsMonthly % 10000L == 0L, "Illegal quota of query, must be not less than 100 thousand and be multiple of QUERY_QUOTA_UNIT(100 thousand).");
        Validate.checkIsTrue(storeBytesQuota >= 0L && storeBytesQuota % 0x40000000L == 0L, "Illegal quota of storage, must be non-negative and be multiple of STORAGE_QUOTA_UNIT(1G).");
        if (timeSeriesQuota <= 0L) {
            timeSeriesQuota = QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly);
        }
        if (ingestDataPointsMonthly < 1000000000L) {
            Validate.checkIsTrue(timeSeriesQuota == QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly), String.format("Illegal quota of timeseries, must be consistent with the result of the QuotaCalculator, excepted %s but got %s.", QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly), timeSeriesQuota));
        } else {
            Validate.checkIsTrue(timeSeriesQuota >= QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly) && timeSeriesQuota % 1000000L == 0L, "Illegal quota of timeseries, must be multiple of ADDITIONAL_TIMESERIES_QUOTA(1 million.");
        }
        if (storeBytesQuota > 0L && lengthLimitMultipleQuota == 0) {
            lengthLimitMultipleQuota = 1;
        }
        Validate.checkIsTrue(storeBytesQuota == 0L && lengthLimitMultipleQuota == 0 || storeBytesQuota > 0L && lengthLimitMultipleQuota > 0, "Illegal quota of lengthLimitMultipleQuota, must be consistent with the storage bytes quota.");
        this.databaseId = databaseId;
        this.ingestDataPointsMonthly = ingestDataPointsMonthly;
        this.queryUnitsMonthly = queryUnitsMonthly;
        this.storeBytesQuota = storeBytesQuota;
        this.timeSeriesQuota = timeSeriesQuota;
        this.lengthLimitMultipleQuota = lengthLimitMultipleQuota;
        this.couponName = couponName;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public static ResizeDatabaseRequestBuilder builder() {
        return new ResizeDatabaseRequestBuilder();
    }

    @NonNull
    public String getDatabaseId() {
        return this.databaseId;
    }

    public long getIngestDataPointsMonthly() {
        return this.ingestDataPointsMonthly;
    }

    public long getQueryUnitsMonthly() {
        return this.queryUnitsMonthly;
    }

    public long getStoreBytesQuota() {
        return this.storeBytesQuota;
    }

    public long getTimeSeriesQuota() {
        return this.timeSeriesQuota;
    }

    public int getLengthLimitMultipleQuota() {
        return this.lengthLimitMultipleQuota;
    }

    public String getCouponName() {
        return this.couponName;
    }

    public void setDatabaseId(@NonNull String databaseId) {
        if (databaseId == null) {
            throw new NullPointerException("databaseId is marked @NonNull but is null");
        }
        this.databaseId = databaseId;
    }

    public void setIngestDataPointsMonthly(long ingestDataPointsMonthly) {
        this.ingestDataPointsMonthly = ingestDataPointsMonthly;
    }

    public void setQueryUnitsMonthly(long queryUnitsMonthly) {
        this.queryUnitsMonthly = queryUnitsMonthly;
    }

    public void setStoreBytesQuota(long storeBytesQuota) {
        this.storeBytesQuota = storeBytesQuota;
    }

    public void setTimeSeriesQuota(long timeSeriesQuota) {
        this.timeSeriesQuota = timeSeriesQuota;
    }

    public void setLengthLimitMultipleQuota(int lengthLimitMultipleQuota) {
        this.lengthLimitMultipleQuota = lengthLimitMultipleQuota;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResizeDatabaseRequest)) {
            return false;
        }
        ResizeDatabaseRequest other = (ResizeDatabaseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        if (this.getIngestDataPointsMonthly() != other.getIngestDataPointsMonthly()) {
            return false;
        }
        if (this.getQueryUnitsMonthly() != other.getQueryUnitsMonthly()) {
            return false;
        }
        if (this.getStoreBytesQuota() != other.getStoreBytesQuota()) {
            return false;
        }
        if (this.getTimeSeriesQuota() != other.getTimeSeriesQuota()) {
            return false;
        }
        if (this.getLengthLimitMultipleQuota() != other.getLengthLimitMultipleQuota()) {
            return false;
        }
        String this$couponName = this.getCouponName();
        String other$couponName = other.getCouponName();
        return !(this$couponName == null ? other$couponName != null : !this$couponName.equals(other$couponName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResizeDatabaseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        long $ingestDataPointsMonthly = this.getIngestDataPointsMonthly();
        result = result * 59 + (int)($ingestDataPointsMonthly >>> 32 ^ $ingestDataPointsMonthly);
        long $queryUnitsMonthly = this.getQueryUnitsMonthly();
        result = result * 59 + (int)($queryUnitsMonthly >>> 32 ^ $queryUnitsMonthly);
        long $storeBytesQuota = this.getStoreBytesQuota();
        result = result * 59 + (int)($storeBytesQuota >>> 32 ^ $storeBytesQuota);
        long $timeSeriesQuota = this.getTimeSeriesQuota();
        result = result * 59 + (int)($timeSeriesQuota >>> 32 ^ $timeSeriesQuota);
        result = result * 59 + this.getLengthLimitMultipleQuota();
        String $couponName = this.getCouponName();
        result = result * 59 + ($couponName == null ? 43 : $couponName.hashCode());
        return result;
    }

    public String toString() {
        return "ResizeDatabaseRequest(databaseId=" + this.getDatabaseId() + ", ingestDataPointsMonthly=" + this.getIngestDataPointsMonthly() + ", queryUnitsMonthly=" + this.getQueryUnitsMonthly() + ", storeBytesQuota=" + this.getStoreBytesQuota() + ", timeSeriesQuota=" + this.getTimeSeriesQuota() + ", lengthLimitMultipleQuota=" + this.getLengthLimitMultipleQuota() + ", couponName=" + this.getCouponName() + ")";
    }

    public static class ResizeDatabaseRequestBuilder {
        private String databaseId;
        private long ingestDataPointsMonthly;
        private long queryUnitsMonthly;
        private long storeBytesQuota;
        private long timeSeriesQuota;
        private int lengthLimitMultipleQuota;
        private String couponName;

        ResizeDatabaseRequestBuilder() {
        }

        public ResizeDatabaseRequestBuilder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public ResizeDatabaseRequestBuilder ingestDataPointsMonthly(long ingestDataPointsMonthly) {
            this.ingestDataPointsMonthly = ingestDataPointsMonthly;
            return this;
        }

        public ResizeDatabaseRequestBuilder queryUnitsMonthly(long queryUnitsMonthly) {
            this.queryUnitsMonthly = queryUnitsMonthly;
            return this;
        }

        public ResizeDatabaseRequestBuilder storeBytesQuota(long storeBytesQuota) {
            this.storeBytesQuota = storeBytesQuota;
            return this;
        }

        public ResizeDatabaseRequestBuilder timeSeriesQuota(long timeSeriesQuota) {
            this.timeSeriesQuota = timeSeriesQuota;
            return this;
        }

        public ResizeDatabaseRequestBuilder lengthLimitMultipleQuota(int lengthLimitMultipleQuota) {
            this.lengthLimitMultipleQuota = lengthLimitMultipleQuota;
            return this;
        }

        public ResizeDatabaseRequestBuilder couponName(String couponName) {
            this.couponName = couponName;
            return this;
        }

        public ResizeDatabaseRequest build() {
            return new ResizeDatabaseRequest(this.databaseId, this.ingestDataPointsMonthly, this.queryUnitsMonthly, this.storeBytesQuota, this.timeSeriesQuota, this.lengthLimitMultipleQuota, this.couponName);
        }

        public String toString() {
            return "ResizeDatabaseRequest.ResizeDatabaseRequestBuilder(databaseId=" + this.databaseId + ", ingestDataPointsMonthly=" + this.ingestDataPointsMonthly + ", queryUnitsMonthly=" + this.queryUnitsMonthly + ", storeBytesQuota=" + this.storeBytesQuota + ", timeSeriesQuota=" + this.timeSeriesQuota + ", lengthLimitMultipleQuota=" + this.lengthLimitMultipleQuota + ", couponName=" + this.couponName + ")";
        }
    }
}

