/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.model.AbstractTableStorageRequest;
import com.baidubce.services.tablestorage.model.CompressType;
import com.baidubce.services.tablestorage.model.TableOption;

public class CreateTableRequest
extends AbstractTableStorageRequest {
    private TableOption tableOption;

    public CreateTableRequest(String tableName, TableOption option) {
        super(tableName);
        this.tableOption = option;
    }

    @Override
    public String toJsonString() {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append("\"tableVersion\":");
        if (this.tableOption.getTableVersion() != 0L) {
            throw new BceClientException("The tableVersion's value must be 0 in CreateTableRequest.");
        }
        buffer.append(this.tableOption.getTableVersion());
        buffer.append(",\"compressType\":\"");
        if (this.tableOption.getCompressType() != CompressType.DEFAULT) {
            buffer.append(this.tableOption.getCompressType().toString());
        } else {
            buffer.append(CompressType.NONE.toString());
        }
        buffer.append("\"");
        buffer.append(",\"ttl\":");
        long timeToLive = this.tableOption.getTimeToLive();
        if (timeToLive >= 82800L || timeToLive == 0L) {
            buffer.append(this.tableOption.getTimeToLive());
        } else if (timeToLive == -1L) {
            buffer.append(0);
        } else {
            throw new BceClientException("The timeToLive's value must be -1 or greater than 82800. timeToLive=" + timeToLive + ".");
        }
        buffer.append(",\"maxVersions\":");
        int maxVersions = this.tableOption.getMaxVersions();
        if (maxVersions > 0) {
            buffer.append(this.tableOption.getMaxVersions());
        } else if (this.tableOption.getMaxVersions() == 0) {
            buffer.append(0);
        } else {
            throw new BceClientException("The maxVersions' value must be positive, or equal to DEFAULT_TABLE_MAX_VERSIONS 0. maxVersions=" + maxVersions + ".");
        }
        String storageType = this.tableOption.getStorageType();
        if (!storageType.equals("")) {
            if (storageType.equals("HighPerformance") || storageType.equals("CommonPerformance")) {
                buffer.append(",\"storageType\":\"");
                buffer.append(storageType);
                buffer.append("\"");
            } else {
                throw new BceClientException("The storageType's value must be HighPerformance or CommonPerformance");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }
}

