/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.tablestorage.TableStorageJsonResponseHandler;
import com.baidubce.services.tablestorage.model.AbstractTableStorageRequest;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractTableStorageBceClient
extends AbstractBceClient {
    private static final HttpResponseHandler[] TABLE_STORAGE_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new TableStorageJsonResponseHandler()};

    public AbstractTableStorageBceClient(BceClientConfiguration config, boolean isHttpAsyncPutEnabled) {
        super(config, TABLE_STORAGE_HANDLERS, isHttpAsyncPutEnabled);
    }

    protected InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add("v1");
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        InternalRequest request = new InternalRequest(httpMethod, HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()])));
        request.setCredentials(bceRequest.getRequestCredentials());
        request.addHeader("Content-Type", "application/json");
        request.addHeader("x-bce-date", DateUtils.formatAlternateIso8601Date(new Date()));
        SignOptions signOptions = new SignOptions();
        signOptions.addHeadersToSign("host");
        request.setSignOptions(signOptions);
        return request;
    }

    protected void fillInHeadAndBody(AbstractTableStorageRequest tableStorageRequest, InternalRequest request) {
        try {
            byte[] json = tableStorageRequest.toJsonString().getBytes("UTF-8");
            if (json.length > 0xA00000) {
                throw new BceClientException("Request body's size should not exceed the limit 10485760. request=" + tableStorageRequest.getClass().getSimpleName() + ", tableName=" + tableStorageRequest.getTableName() + ", bodySize=" + json.length + ".");
            }
            request.setContent(RestartableInputStream.wrap(json));
            request.addHeader("Content-Length", String.valueOf(json.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Request body don't support UTF-8 encode.", e);
        }
    }
}

