/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.oos;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.oos.model.common.TemplateType;
import com.baidubce.services.oos.model.request.BaseExecutionRequest;
import com.baidubce.services.oos.model.request.BaseTemplateRequest;
import com.baidubce.services.oos.model.request.OperatorListRequest;
import com.baidubce.services.oos.model.request.TemplateListRequest;
import com.baidubce.services.oos.model.response.BaseExecutionResponse;
import com.baidubce.services.oos.model.response.BaseTemplateResponse;
import com.baidubce.services.oos.model.response.CheckTemplateResponse;
import com.baidubce.services.oos.model.response.OperatorListResponse;
import com.baidubce.services.oos.model.response.TemplateListResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class OosClient
extends AbstractBceClient {
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] OOS_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public OosClient() {
        this(new BceClientConfiguration());
    }

    public OosClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, OOS_HANDLERS);
    }

    private InternalRequest createRequestWithUrl(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String url) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), url);
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private InternalRequest createBodyRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String url) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), url);
        InternalRequest request = new InternalRequest(httpMethod, uri);
        this.fillPayload(request, bceRequest);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT || internalRequest.getHttpMethod() == HttpMethodName.PATCH) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public BaseTemplateResponse createTemplate(BaseTemplateRequest request) {
        this.checkBaseTemplateRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/api/logic/oos/v2/template");
        return this.invokeHttpClient(internalRequest, BaseTemplateResponse.class);
    }

    public CheckTemplateResponse checkTemplate(BaseTemplateRequest request) {
        this.checkBaseTemplateRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/api/logic/oos/v2/template/check");
        return this.invokeHttpClient(internalRequest, CheckTemplateResponse.class);
    }

    public BaseTemplateResponse updateTemplate(BaseTemplateRequest request) {
        this.checkBaseTemplateRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, "/api/logic/oos/v2/template");
        return this.invokeHttpClient(internalRequest, BaseTemplateResponse.class);
    }

    public BaseTemplateResponse deleteTemplate(String templateId) {
        Validate.checkStringNotEmpty(templateId, StringFormatUtils.checkEmptyExceptionMessageFormat("templateId"));
        BaseTemplateRequest request = new BaseTemplateRequest();
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.DELETE, "/api/logic/oos/v2/template");
        internalRequest.addParameter("id", templateId);
        return this.invokeHttpClient(internalRequest, BaseTemplateResponse.class);
    }

    public BaseTemplateResponse getTemplateDetail(String templateName, TemplateType templateType) {
        Validate.checkStringNotEmpty(templateName, StringFormatUtils.checkEmptyExceptionMessageFormat("templateName"));
        BaseTemplateRequest request = new BaseTemplateRequest();
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, "/api/logic/oos/v2/template");
        internalRequest.addParameter("name", templateName);
        internalRequest.addParameter("type", templateType.toString());
        return this.invokeHttpClient(internalRequest, BaseTemplateResponse.class);
    }

    public TemplateListResponse getTemplateList(TemplateListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkIsTrue(request.getPageNo() > 0, "pageNo should gt 0");
        Validate.checkIsTrue(request.getPageSize() > 0 && request.getPageSize() <= 100, "pageSize should gt 0 and lt 100");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/api/logic/oos/v2/template/list");
        return this.invokeHttpClient(internalRequest, TemplateListResponse.class);
    }

    public OperatorListResponse getOperatorList(OperatorListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkIsTrue(request.getPageNo() > 0, "pageNo should gt 0");
        Validate.checkIsTrue(request.getPageSize() > 0 && request.getPageSize() <= 100, "pageSize should gt 0 and lt 100");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/api/logic/oos/v1/operator/list");
        return this.invokeHttpClient(internalRequest, OperatorListResponse.class);
    }

    public BaseExecutionResponse createExecution(BaseExecutionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkIsTrue(null != request.getTemplate(), "template should not be null");
        Validate.checkIsTrue(StringUtils.isNotEmpty((String)request.getTemplate().getName()) || StringUtils.isNotEmpty((String)request.getTemplate().getRef()), "neither template ref nor template name is set");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/api/logic/oos/v2/execution");
        return this.invokeHttpClient(internalRequest, BaseExecutionResponse.class);
    }

    public BaseExecutionResponse getExecutionDetail(String executionId) {
        Validate.checkStringNotEmpty(executionId, StringFormatUtils.checkEmptyExceptionMessageFormat("executionId"));
        BaseExecutionRequest request = new BaseExecutionRequest();
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, "/api/logic/oos/v2/execution");
        internalRequest.addParameter("id", executionId);
        return this.invokeHttpClient(internalRequest, BaseExecutionResponse.class);
    }

    private void checkBaseTemplateRequest(BaseTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getOperators()), "operators should not be empty");
        if (CollectionUtils.isEmpty(request.getLinks())) {
            Validate.checkIsTrue(request.isLinear(), "linear is false, links should not be empty");
        }
    }
}

