/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.media.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.media.model.PipelineConfig;
import com.baidubce.services.media.model.PipelineStatus;
import com.baidubce.util.Validate;

public class UpdatePipelineRequest
extends AbstractBceRequest {
    private String pipelineName = null;
    private String description = null;
    private String sourceBucket = null;
    private String targetBucket = null;
    private PipelineConfig config = null;

    public UpdatePipelineRequest withPipelineName(String pipelineName) {
        Validate.checkStringNotEmpty(pipelineName, "The parameter pipelineName should NOT be null or empty string.");
        this.pipelineName = pipelineName;
        return this;
    }

    public UpdatePipelineRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public UpdatePipelineRequest withSourceBucket(String sourceBucket) {
        Validate.checkStringNotEmpty(sourceBucket, "The parameter sourceBucket should NOT be null or empty string.");
        this.sourceBucket = sourceBucket;
        return this;
    }

    public UpdatePipelineRequest withTargetBucket(String targetBucket) {
        Validate.checkStringNotEmpty(targetBucket, "The parameter targetBucket should NOT be null or empty string.");
        this.targetBucket = targetBucket;
        return this;
    }

    public UpdatePipelineRequest withConfig(PipelineConfig config) {
        this.config = config;
        return this;
    }

    public UpdatePipelineRequest withPipeline(PipelineStatus pipeline) {
        this.pipelineName = pipeline.getPipelineName();
        this.description = pipeline.getDescription();
        this.sourceBucket = pipeline.getSourceBucket();
        this.targetBucket = pipeline.getTargetBucket();
        this.config = pipeline.getConfig();
        return this;
    }

    @Override
    public UpdatePipelineRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdatePipelineRequest {\n");
        sb.append("    : ").append(this.pipelineName).append("\n");
        sb.append("    : ").append(this.description).append("\n");
        sb.append("    : ").append(this.sourceBucket).append("\n");
        sb.append("    : ").append(this.targetBucket).append("\n");
        sb.append("    : ").append(this.config).append("\n");
        sb.append("}\n");
        return sb.toString();
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public String getTargetBucket() {
        return this.targetBucket;
    }

    public PipelineConfig getConfig() {
        return this.config;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public void setTargetBucket(String targetBucket) {
        this.targetBucket = targetBucket;
    }

    public void setConfig(PipelineConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pipelineName = this.getPipelineName();
        String other$pipelineName = other.getPipelineName();
        if (this$pipelineName == null ? other$pipelineName != null : !this$pipelineName.equals(other$pipelineName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$sourceBucket = this.getSourceBucket();
        String other$sourceBucket = other.getSourceBucket();
        if (this$sourceBucket == null ? other$sourceBucket != null : !this$sourceBucket.equals(other$sourceBucket)) {
            return false;
        }
        String this$targetBucket = this.getTargetBucket();
        String other$targetBucket = other.getTargetBucket();
        if (this$targetBucket == null ? other$targetBucket != null : !this$targetBucket.equals(other$targetBucket)) {
            return false;
        }
        PipelineConfig this$config = this.getConfig();
        PipelineConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdatePipelineRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pipelineName = this.getPipelineName();
        result = result * 59 + ($pipelineName == null ? 43 : $pipelineName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $sourceBucket = this.getSourceBucket();
        result = result * 59 + ($sourceBucket == null ? 43 : $sourceBucket.hashCode());
        String $targetBucket = this.getTargetBucket();
        result = result * 59 + ($targetBucket == null ? 43 : $targetBucket.hashCode());
        PipelineConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }
}

