/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp.model.service;

import com.baidubce.model.GenericAccountRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SendMessageRequest
extends GenericAccountRequest {
    @NonNull
    private String topic;
    @NonNull
    private String message;

    public static SendMessageRequestBuilder builder() {
        return new SendMessageRequestBuilder();
    }

    @NonNull
    public String getTopic() {
        return this.topic;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    public void setTopic(@NonNull String topic) {
        if (topic == null) {
            throw new NullPointerException("topic is marked @NonNull but is null");
        }
        this.topic = topic;
    }

    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendMessageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "SendMessageRequest(topic=" + this.getTopic() + ", message=" + this.getMessage() + ")";
    }

    public SendMessageRequest(@NonNull String topic, @NonNull String message) {
        if (topic == null) {
            throw new NullPointerException("topic is marked @NonNull but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        this.topic = topic;
        this.message = message;
    }

    public static class SendMessageRequestBuilder {
        private String topic;
        private String message;

        SendMessageRequestBuilder() {
        }

        public SendMessageRequestBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public SendMessageRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SendMessageRequest build() {
            return new SendMessageRequest(this.topic, this.message);
        }

        public String toString() {
            return "SendMessageRequest.SendMessageRequestBuilder(topic=" + this.topic + ", message=" + this.message + ")";
        }
    }
}

