/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cfs.v2;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.common.ApiInfo;
import com.baidubce.common.BaseBceClient;
import com.baidubce.common.BaseBceResponse;
import com.baidubce.common.BceRegion;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.cfs.v2.api.CfsApi;
import com.baidubce.services.cfs.v2.model.CreateFSRequest;
import com.baidubce.services.cfs.v2.model.CreateFSResponse;
import com.baidubce.services.cfs.v2.model.CreateMountTargetRequest;
import com.baidubce.services.cfs.v2.model.CreateMountTargetResponse;
import com.baidubce.services.cfs.v2.model.DescribeFsRequest;
import com.baidubce.services.cfs.v2.model.DescribeFsResponse;
import com.baidubce.services.cfs.v2.model.DescribeMountTargetRequest;
import com.baidubce.services.cfs.v2.model.DescribeMountTargetResponse;
import com.baidubce.services.cfs.v2.model.DropFsRequest;
import com.baidubce.services.cfs.v2.model.GetFsQuotaResponse;
import com.baidubce.services.cfs.v2.model.UpdateFsRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CfsClient
extends BaseBceClient {
    private static final Map<BceRegion, String> ENDPOINTS = ImmutableMap.builder().put((Object)BceRegion.DEFAULT, (Object)"http://cfs.bj.baidubce.com").put((Object)BceRegion.BJ, (Object)"http://cfs.bj.baidubce.com").put((Object)BceRegion.BD, (Object)"http://cfs.bd.baidubce.com").put((Object)BceRegion.SU, (Object)"http://cfs.su.baidubce.com").put((Object)BceRegion.GZ, (Object)"http://cfs.gz.baidubce.com").put((Object)BceRegion.FWH, (Object)"http://cfs.fwh.baidubce.com").put((Object)BceRegion.HKG, (Object)"http://cfs.hkg.baidubce.com").build();
    private static final String SERVICE_ID = "Cfs";
    private static final Map<String, ApiInfo> CFS_APIS = CfsApi.getApis();

    public CfsClient(String ak, String sk, BceRegion region) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)region));
    }

    public CfsClient(String ak, String sk) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)BceRegion.DEFAULT));
    }

    public CfsClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public CreateFSResponse createFS(CreateFSRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("createFS"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateFSResponse.class);
    }

    public CreateMountTargetResponse createMountTarget(String fsId, CreateMountTargetRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("createMountTarget"));
        String apiPath = apiInfo.getPath().withPathParameter("fsId", fsId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateMountTargetResponse.class);
    }

    public void deleteMountTarget(String fsId, String mountId) {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("deleteMountTarget"));
        String apiPath = apiInfo.getPath().withPathParameter("fsId", fsId).withPathParameter("mountId", mountId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public DescribeFsResponse describeFs(DescribeFsRequest body, String userId, String fsId, String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("describeFs"));
        String apiPath = apiInfo.getPath().get();
        if (userId.length() == 0 && fsId.length() == 0) {
            throw new BceClientException("Invalid request, userId or fsId should not be empty");
        }
        if (userId.length() != 0) {
            apiInfo.getQueries().put("userId", userId);
        }
        if (fsId.length() != 0) {
            apiInfo.getQueries().put("fsId", fsId);
        }
        if (marker.length() != 0) {
            apiInfo.getQueries().put("marker", marker);
        }
        if (maxKeys > 0) {
            apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        }
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, DescribeFsResponse.class);
    }

    public DescribeMountTargetResponse describeMountTarget(String fsId, DescribeMountTargetRequest body, String mountId, String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("describeMountTarget"));
        String apiPath = apiInfo.getPath().withPathParameter("fsId", fsId).get();
        if (mountId.length() != 0) {
            apiInfo.getQueries().put("mountId", mountId);
        }
        if (marker.length() != 0) {
            apiInfo.getQueries().put("marker", marker);
        }
        if (maxKeys > 0) {
            apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        }
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, DescribeMountTargetResponse.class);
    }

    public void dropFs(String fsId, DropFsRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("dropFs"));
        String apiPath = apiInfo.getPath().withPathParameter("fsId", fsId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public GetFsQuotaResponse getFsQuota() {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("getFsQuota"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetFsQuotaResponse.class);
    }

    public void updateFs(String fsId, UpdateFsRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFS_APIS.get("updateFs"));
        String apiPath = apiInfo.getPath().withPathParameter("fsId", fsId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }
}

