/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos;

import com.baidubce.http.BceHttpResponse;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bos.BosObjectInputStream;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.GetObjectResponse;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.util.LengthCheckInputStream;
import com.google.common.base.CharMatcher;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BosObjectResponseHandler
implements HttpResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(BosObjectResponseHandler.class);
    private static final String DEFAULT_ENCODING = "UTF-8";

    @Override
    public boolean handle(BceHttpResponse httpResponse, AbstractBceResponse response) throws Exception {
        int pos;
        if (!(response instanceof GetObjectResponse)) {
            return false;
        }
        BosObject object = new BosObject();
        ObjectMetadata objectMetadata = object.getObjectMetadata();
        objectMetadata.setContentLength(httpResponse.getHeaderAsLong("Content-Length"));
        objectMetadata.setContentType(httpResponse.getHeader("Content-Type"));
        objectMetadata.setContentEncoding(httpResponse.getHeader("Content-Encoding"));
        objectMetadata.setContentMd5(httpResponse.getHeader("Content-MD5"));
        objectMetadata.setExpires(httpResponse.getHeader("Expires"));
        objectMetadata.setObjectType(httpResponse.getHeader("x-bce-object-type"));
        objectMetadata.setAppendOffset(httpResponse.getHeaderAsLong("x-bce-next-append-offset"));
        objectMetadata.setContentDisposition(httpResponse.getHeader("Content-Disposition"));
        objectMetadata.setCacheControl(httpResponse.getHeader("Cache-Control"));
        objectMetadata.setxBceCrc(httpResponse.getHeader("x-bce-content-crc32"));
        objectMetadata.setxBceCrc32c(httpResponse.getHeader("x-bce-content-crc32c"));
        objectMetadata.setRestore(httpResponse.getHeader("x-bce-restore"));
        String storageClass = httpResponse.getHeader("x-bce-storage-class");
        if (storageClass == null) {
            storageClass = "STANDARD";
        }
        objectMetadata.setStorageClass(storageClass);
        String eTag = httpResponse.getHeader("ETag");
        if (eTag != null) {
            objectMetadata.setETag(CharMatcher.is((char)'\"').trimFrom((CharSequence)eTag));
        }
        objectMetadata.setContentLength(objectMetadata.getContentLength());
        String contentRange = httpResponse.getHeader("Content-Range");
        objectMetadata.setContentRange(contentRange);
        if (contentRange != null && (pos = contentRange.lastIndexOf(47)) >= 0) {
            try {
                objectMetadata.setInstanceLength(Long.parseLong(contentRange.substring(pos + 1)));
            }
            catch (NumberFormatException e) {
                logger.warn("Fail to parse length from Content-Range: " + contentRange, (Throwable)e);
            }
        }
        objectMetadata.setLastModified(httpResponse.getHeaderAsRfc822Date("Last-Modified"));
        objectMetadata.setBceContentSha256(httpResponse.getHeader("x-bce-content-sha256"));
        for (Map.Entry<String, String> header : httpResponse.getHeaders().entrySet()) {
            String key = header.getKey();
            if (!key.startsWith("x-bce-meta-")) continue;
            key = key.substring("x-bce-meta-".length());
            objectMetadata.addUserMetadata(URLDecoder.decode(key, DEFAULT_ENCODING), URLDecoder.decode(header.getValue(), DEFAULT_ENCODING));
        }
        InputStream content = httpResponse.getContent();
        if (content != null) {
            if (objectMetadata.getContentLength() >= 0L) {
                content = new LengthCheckInputStream(content, objectMetadata.getContentLength(), true);
            }
            object.setObjectContent(new BosObjectInputStream(content, httpResponse.getHttpResponse()));
        }
        ((GetObjectResponse)response).setObject(object);
        return true;
    }
}

