/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vpc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.vpc.VpcClientConfiguration;
import com.baidubce.services.vpc.model.CreateVpcRequest;
import com.baidubce.services.vpc.model.CreateVpcResponse;
import com.baidubce.services.vpc.model.DeleteVpcRequest;
import com.baidubce.services.vpc.model.GetVpcPrivateAddressInfoResponse;
import com.baidubce.services.vpc.model.GetVpcPrivateIpAddressInfoRequest;
import com.baidubce.services.vpc.model.GetVpcRequest;
import com.baidubce.services.vpc.model.GetVpcResponse;
import com.baidubce.services.vpc.model.ListVpcRequest;
import com.baidubce.services.vpc.model.ListVpcResponse;
import com.baidubce.services.vpc.model.ModifyVpcAttributesRequest;
import com.baidubce.services.vpc.model.NetworkAction;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpcClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(VpcClient.class);
    private static final String VERSION = "v1";
    private static final String VPC_PREFIX = "vpc";
    private static final String VPC_PRIVATE_IP_PREFIX = "privateIpAddressInfo";
    private static final HttpResponseHandler[] vpcHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VpcClient() {
        this(new VpcClientConfiguration());
    }

    public VpcClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, vpcHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateVpcResponse createVpc(String name, String cidr) {
        CreateVpcRequest request = new CreateVpcRequest();
        request.withName(name).withCidr(cidr);
        return this.createVpc(request);
    }

    public CreateVpcResponse createVpc(CreateVpcRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getName(), "name should not be empty");
        Validate.checkStringNotEmpty(request.getCidr(), "cidr should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VPC_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateVpcResponse.class);
    }

    public ListVpcResponse listVpcs() {
        return this.listVpcs(new ListVpcRequest());
    }

    public ListVpcResponse listVpcs(ListVpcRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (request.getIsDefault() != null) {
            internalRequest.addParameter("isDefault", request.getIsDefault().toString());
        }
        return this.invokeHttpClient(internalRequest, ListVpcResponse.class);
    }

    public GetVpcResponse getVpc(String vpcId) {
        return this.getVpc(new GetVpcRequest().withVpcId(vpcId));
    }

    public GetVpcResponse getVpc(GetVpcRequest getVpcRequest) {
        Preconditions.checkNotNull((Object)getVpcRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)getVpcRequest.getVpcId(), (Object)"request vpcId should not be null.");
        InternalRequest internalRequest = this.createRequest(getVpcRequest, HttpMethodName.GET, VPC_PREFIX, getVpcRequest.getVpcId());
        return this.invokeHttpClient(internalRequest, GetVpcResponse.class);
    }

    public void deleteVpc(String vpcId) {
        this.deleteVpc(new DeleteVpcRequest().withVpcId(vpcId));
    }

    public void deleteVpc(DeleteVpcRequest deleteVpcRequest) {
        Preconditions.checkNotNull((Object)deleteVpcRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)deleteVpcRequest.getVpcId(), (Object)"request vpcId should not be null.");
        if (Strings.isNullOrEmpty((String)deleteVpcRequest.getClientToken())) {
            deleteVpcRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteVpcRequest, HttpMethodName.DELETE, VPC_PREFIX, deleteVpcRequest.getVpcId());
        internalRequest.addParameter("clientToken", deleteVpcRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstanceAttributes(String name, String vpcId) {
        ModifyVpcAttributesRequest request = new ModifyVpcAttributesRequest();
        this.modifyInstanceAttributes(request.withName(name).withVpcId(vpcId));
    }

    public void modifyInstanceAttributes(ModifyVpcAttributesRequest modifyVpcAttributesRequest) {
        Preconditions.checkNotNull((Object)modifyVpcAttributesRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(modifyVpcAttributesRequest.getVpcId(), "request vpcId should not be empty.");
        Validate.checkStringNotEmpty(modifyVpcAttributesRequest.getName(), "request name should not be empty.");
        if (Strings.isNullOrEmpty((String)modifyVpcAttributesRequest.getClientToken())) {
            modifyVpcAttributesRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(modifyVpcAttributesRequest, HttpMethodName.PUT, VPC_PREFIX, modifyVpcAttributesRequest.getVpcId());
        internalRequest.addParameter(NetworkAction.modifyAttribute.name(), null);
        internalRequest.addParameter("clientToken", modifyVpcAttributesRequest.getClientToken());
        this.fillPayload(internalRequest, modifyVpcAttributesRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetVpcPrivateAddressInfoResponse getVpcPrivateIpAddressInfo(GetVpcPrivateIpAddressInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVpcId(), "request vpcId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX, request.getVpcId(), VPC_PRIVATE_IP_PREFIX);
        if (CollectionUtils.isNotEmpty(request.getPrivateIpAddresses())) {
            StringBuilder privateIpAddresses = new StringBuilder();
            for (String privateIpAddress : request.getPrivateIpAddresses()) {
                privateIpAddresses.append(privateIpAddress).append(",");
            }
            privateIpAddresses.deleteCharAt(privateIpAddresses.lastIndexOf(","));
            internalRequest.addParameter("privateIpAddresses", privateIpAddresses.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getPrivateIpRange())) {
            internalRequest.addParameter("privateIpRange", request.getPrivateIpRange());
        }
        return this.invokeHttpClient(internalRequest, GetVpcPrivateAddressInfoResponse.class);
    }
}

