/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothub;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.iothub.model.BaseRequest;
import com.baidubce.services.iothub.model.BaseResponse;
import com.baidubce.services.iothub.model.iotcore.AddPolicyRequest;
import com.baidubce.services.iothub.model.iotcore.AddPolicyResponse;
import com.baidubce.services.iothub.model.iotcore.AlgorithmType;
import com.baidubce.services.iothub.model.iotcore.CreateDeviceRequest;
import com.baidubce.services.iothub.model.iotcore.CreateDeviceResponse;
import com.baidubce.services.iothub.model.iotcore.CreateTemplateRequest;
import com.baidubce.services.iothub.model.iotcore.CreateTemplateResponse;
import com.baidubce.services.iothub.model.iotcore.GetDeviceResponse;
import com.baidubce.services.iothub.model.iotcore.GetDeviceSignatureResponse;
import com.baidubce.services.iothub.model.iotcore.GetTemplateResponse;
import com.baidubce.services.iothub.model.iotcore.PaginationResponse;
import com.baidubce.services.iothub.model.iotcore.ResetDeviceSecretResponse;
import com.baidubce.services.iothub.model.iotcore.ScrollPaginationResponse;
import com.baidubce.services.iothub.model.iotcore.SecretKeyRequest;
import com.baidubce.services.iothub.model.iotcore.UpdateDeviceRequest;
import com.baidubce.services.iothub.model.iotcore.UpdateDeviceResponse;
import com.baidubce.services.iothub.model.iotcore.UpdatePolicyRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class IoTCoreClient
extends AbstractBceClient {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String ENDPOINT_HOST = "iot.baidubce.com";
    private static final String VERSION = "v1";
    private static final String IOT_CORE = "iotcore";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host", "x-bce-date"};
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String DEVICE = "device";
    private static final String NEW = "new";
    private static final String SCROLL = "scroll";
    private static final String LIST = "list";
    private static final String SIGNATURE = "signature";
    private static final String SECRET = "secret";
    private static final String TEMPLATE = "template";
    private static final String POLICY = "policy";
    private static final HttpResponseHandler[] IOTCORE_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public IoTCoreClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT_HOST) : config, IOTCORE_HANDLERS);
    }

    public CreateDeviceResponse createDevice(String iotCoreId, CreateDeviceRequest createDeviceRequest) {
        Preconditions.checkNotNull((Object)createDeviceRequest, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)createDeviceRequest, (Object)"request should not be null.");
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)createDeviceRequest, HttpMethodName.POST, iotCoreId, DEVICE, NEW), CreateDeviceResponse.class);
    }

    public GetDeviceResponse getDevice(String iotCoreId, String deviceName) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)deviceName, (Object)"deviceName should not be null.");
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.GET, iotCoreId, DEVICE, deviceName), GetDeviceResponse.class);
    }

    public UpdateDeviceResponse updateDevice(String iotCoreId, String deviceName, UpdateDeviceRequest updateDeviceRequest) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)deviceName, (Object)"deviceName should not be null.");
        Preconditions.checkNotNull((Object)updateDeviceRequest, (Object)"request should not be null.");
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)updateDeviceRequest, HttpMethodName.PUT, iotCoreId, DEVICE, deviceName), UpdateDeviceResponse.class);
    }

    public void deleteDevice(String iotCoreId, String deviceName) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)deviceName, (Object)"deviceName should not be null.");
        this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.DELETE, iotCoreId, DEVICE, deviceName), BaseResponse.class);
    }

    public ScrollPaginationResponse<GetDeviceResponse> getDevices(String iotCoreId) {
        return this.getDevices(iotCoreId, System.currentTimeMillis(), 20, "");
    }

    public ScrollPaginationResponse<GetDeviceResponse> getDevices(String iotCoreId, long createTimeBefore, int pageSize, String deviceNamePrefix) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)deviceNamePrefix, (Object)"deviceNamePrefix should not be null.");
        Preconditions.checkArgument((createTimeBefore > 0L ? 1 : 0) != 0, (Object)"Illegal create time before");
        Preconditions.checkArgument((pageSize > 0 && pageSize < 200 ? 1 : 0) != 0, (Object)"Illegal page size");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("createTimeBefore", String.valueOf(createTimeBefore));
        parameters.put("pageSize", String.valueOf(pageSize));
        parameters.put("name", deviceNamePrefix);
        ScrollPaginationResponse response = this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.GET, parameters, iotCoreId, DEVICE, SCROLL, LIST), ScrollPaginationResponse.class);
        ArrayList<Object> responses = new ArrayList<Object>();
        for (Object data : response.getData()) {
            responses.add(mapper.convertValue(data, GetDeviceResponse.class));
        }
        return new ScrollPaginationResponse<GetDeviceResponse>(responses, response.getTotal(), response.getPageSize(), response.getCreateTimeBefore());
    }

    public GetDeviceSignatureResponse getDeviceSignature(String iotCoreId, String deviceName) {
        return this.getDeviceSignature(iotCoreId, deviceName, 0L, AlgorithmType.MD5);
    }

    public GetDeviceSignatureResponse getDeviceSignature(String iotCoreId, String deviceName, long timestamp, AlgorithmType algorithmType) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)deviceName, (Object)"deviceName should not be null.");
        Preconditions.checkNotNull((Object)((Object)algorithmType), (Object)"algorithmType should not be null.");
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (Object)"Illegal timestamp");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("timestamp", String.valueOf(timestamp));
        parameters.put("algorithmType", algorithmType.name());
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.GET, parameters, iotCoreId, DEVICE, deviceName, SIGNATURE), GetDeviceSignatureResponse.class);
    }

    public ResetDeviceSecretResponse resetDeviceSecret(String iotCoreId, String deviceName) {
        return this.resetDeviceSecret(iotCoreId, deviceName, null);
    }

    public ResetDeviceSecretResponse resetDeviceSecret(String iotCoreId, String deviceName, String secretKey) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)deviceName, (Object)"deviceName should not be null.");
        BaseRequest request = secretKey != null ? SecretKeyRequest.builder().secretKey(secretKey).build() : new BaseRequest();
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)request, HttpMethodName.PUT, iotCoreId, DEVICE, deviceName, SECRET), ResetDeviceSecretResponse.class);
    }

    public CreateTemplateResponse createTemplate(String iotCoreId, String templateName) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)templateName, (Object)"templateName should not be null.");
        CreateTemplateRequest request = CreateTemplateRequest.builder().name(templateName).build();
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)request, HttpMethodName.POST, iotCoreId, TEMPLATE), CreateTemplateResponse.class);
    }

    public GetTemplateResponse getTemplate(String iotCoreId, String templateId) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)templateId, (Object)"templateId should not be null.");
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.GET, iotCoreId, TEMPLATE, templateId), GetTemplateResponse.class);
    }

    public PaginationResponse<GetTemplateResponse> getTemplates(String iotCoreId) {
        return this.getTemplates(iotCoreId, 1, 20);
    }

    public PaginationResponse<GetTemplateResponse> getTemplates(String iotCoreId, int pageNo, int pageSize) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkArgument((pageNo > 0 ? 1 : 0) != 0, (Object)"Illegal page no");
        Preconditions.checkArgument((pageSize > 0 && pageSize < 200 ? 1 : 0) != 0, (Object)"Illegal page size");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("pageNo", String.valueOf(pageNo));
        parameters.put("pageSize", String.valueOf(pageSize));
        PaginationResponse response = this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.GET, parameters, iotCoreId, TEMPLATE, LIST), PaginationResponse.class);
        ArrayList<Object> responses = new ArrayList<Object>();
        for (Object data : response.getData()) {
            responses.add(mapper.convertValue(data, GetTemplateResponse.class));
        }
        return new PaginationResponse<GetTemplateResponse>(responses, response.getTotal(), response.getPageNo(), response.getPageSize(), response.getOrder(), response.getOrderBy());
    }

    public void deleteTemplate(String iotCoreId, String templateId) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)templateId, (Object)"iotCoreId should not be null.");
        this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.DELETE, iotCoreId, TEMPLATE, templateId), BaseResponse.class);
    }

    public AddPolicyResponse addPolicy(String iotCoreId, String templateId, AddPolicyRequest request) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)templateId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        return this.invokeHttpClient(this.createRequest((AbstractBceRequest)request, HttpMethodName.POST, iotCoreId, TEMPLATE, templateId, POLICY), AddPolicyResponse.class);
    }

    public void updatePolicy(String iotCoreId, String templateId, String policyId, UpdatePolicyRequest request) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)templateId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)policyId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        this.invokeHttpClient(this.createRequest((AbstractBceRequest)request, HttpMethodName.PUT, iotCoreId, TEMPLATE, templateId, POLICY, policyId), BaseResponse.class);
    }

    public void removePolicy(String iotCoreId, String templateId, String policyId) {
        Preconditions.checkNotNull((Object)iotCoreId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)templateId, (Object)"iotCoreId should not be null.");
        Preconditions.checkNotNull((Object)policyId, (Object)"iotCoreId should not be null.");
        this.invokeHttpClient(this.createRequest((AbstractBceRequest)new BaseRequest(), HttpMethodName.DELETE, iotCoreId, TEMPLATE, templateId, POLICY, policyId), BaseResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, Map<String, String> parameters, String ... pathVariables) {
        return this.createRequest(bceRequest, httpMethod, null, parameters, pathVariables);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        return this.createRequest(bceRequest, httpMethod, (SignOptions)null, (Map<String, String>)null, pathVariables);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, SignOptions signOptions, Map<String, String> parameters, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        path.add(IOT_CORE);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        if (signOptions == null) {
            signOptions = new SignOptions();
            signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        }
        if (parameters != null) {
            request.setParameters(parameters);
        }
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        this.fillInHeadAndBody(bceRequest, request);
        return request;
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

