/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cdn.model.stat;

import com.baidubce.services.cdn.model.CdnRequest;
import com.baidubce.services.cdn.model.GetStatMetricMapping;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GetIpv6StatRequest
extends CdnRequest {
    private String statType;
    private String startTime;
    private String endTime;
    private Integer period = 300;
    private List<String> keys;
    private String prov;
    private String isp;

    public GetIpv6StatRequest withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public GetIpv6StatRequest withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public GetIpv6StatRequest withPeriod(Integer period) {
        this.period = period;
        return this;
    }

    public GetIpv6StatRequest withKeys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    public GetIpv6StatRequest withStatType(String statType) {
        this.statType = statType;
        return this;
    }

    public GetIpv6StatRequest withProv(String prov) {
        this.prov = (String)GetStatMetricMapping.PROVINCE_MAP.inverse().get((Object)prov);
        this.prov = StringUtils.isEmpty((CharSequence)this.prov) ? prov : this.prov;
        return this;
    }

    public GetIpv6StatRequest withIsp(String isp) {
        this.isp = (String)GetStatMetricMapping.ISP_MAP.inverse().get((Object)isp);
        this.isp = StringUtils.isEmpty((CharSequence)this.isp) ? isp : this.isp;
        return this;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public String getProv() {
        return this.prov;
    }

    public void setProv(String prov) {
        this.prov = prov;
    }

    public String getIsp() {
        return this.isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getStatType() {
        return this.statType;
    }

    public void setStatType(String statType) {
        this.statType = statType;
    }
}

