/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.services.bos.model.GenericObjectRequest;
import com.google.common.base.Preconditions;

public class FetchObjectRequest
extends GenericObjectRequest {
    public static final String MODE_SYNC = "sync";
    public static final String MODE_ASYNC = "async";
    private String sourceUrl;
    private String mode;
    private String storageClass;
    private String callbackAddress;
    private String referer;
    private String userAgent;

    public FetchObjectRequest(String bucketName, String key, String sourceUrl) {
        super(bucketName, key);
        this.setSourceUrl(sourceUrl);
        this.setMode(MODE_SYNC);
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        Preconditions.checkNotNull((Object)sourceUrl, (Object)"sourceUrl should not be null");
        this.sourceUrl = sourceUrl;
    }

    public FetchObjectRequest withSourceUrl(String sourceUrl) {
        this.setSourceUrl(sourceUrl);
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        Preconditions.checkNotNull((Object)mode, (Object)"mode should not be null");
        if (!MODE_ASYNC.equals(mode) && !MODE_SYNC.equals(mode)) {
            throw new IllegalArgumentException("illegal mode: " + mode);
        }
        this.mode = mode;
    }

    public FetchObjectRequest withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    @Override
    public FetchObjectRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    @Override
    public FetchObjectRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    @Override
    public FetchObjectRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public FetchObjectRequest withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public String getCallbackAddress() {
        return this.callbackAddress;
    }

    public void setCallbackAddress(String callbackAddress) {
        this.callbackAddress = callbackAddress;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

