/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bci;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bci.BciClientConfiguration;
import com.baidubce.services.bci.model.instance.CreateInstanceRequest;
import com.baidubce.services.bci.model.instance.CreateInstanceResponse;
import com.baidubce.services.bci.model.instance.DeleteInstanceRequest;
import com.baidubce.services.bci.model.instance.DeleteInstanceResponse;
import com.baidubce.services.bci.model.instance.GetInstanceRequest;
import com.baidubce.services.bci.model.instance.GetInstanceResponse;
import com.baidubce.services.bci.model.instance.ListInstancesRequest;
import com.baidubce.services.bci.model.instance.ListInstancesResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BciClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BciClient.class);
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String KEYWORD_TYPE = "keywordType";
    private static final String KEYWORD = "keyword";
    private static final String VERSION = "v2";
    private static final String BCI_PREFIX = "instance";
    private static final String BATCH_DEL = "batchDel";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String INSTANCE_ID_MESSAGE_KEY = "instanceId";
    private static final HttpResponseHandler[] BCI_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BciClient() {
        this(new BciClientConfiguration());
    }

    public BciClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, BCI_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateInstanceResponse createInstance(CreateInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BCI_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateInstanceResponse.class);
    }

    public DeleteInstanceResponse deleteInstance(String instanceId) throws BceClientException {
        return this.deleteInstance(instanceId, false);
    }

    public DeleteInstanceResponse deleteInstance(String instanceId, Boolean relatedReleaseFlag) throws BceClientException {
        Validate.checkStringNotEmpty(instanceId, StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCE_ID_MESSAGE_KEY));
        Validate.checkNotNull(relatedReleaseFlag, "relatedReleaseFlag should not be null.");
        DeleteInstanceRequest request = new DeleteInstanceRequest();
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, BCI_PREFIX, instanceId);
        internalRequest.addParameter("relatedReleaseFlag", relatedReleaseFlag.toString());
        internalRequest.addParameter("clientToken", request.getClientToken());
        return this.invokeHttpClient(internalRequest, DeleteInstanceResponse.class);
    }

    public DeleteInstanceResponse batchDeleteInstance(DeleteInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkNotNull(request.getInstanceIds(), "instanceId should not be null.");
        Validate.checkNotNull(request.getRelatedReleaseFlag(), "relatedReleaseFlag should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BCI_PREFIX, BATCH_DEL);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteInstanceResponse.class);
    }

    public GetInstanceResponse getInstance(String instanceId) throws BceClientException {
        return this.getInstance(new GetInstanceRequest().setInstanceId(instanceId));
    }

    public GetInstanceResponse getInstance(GetInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BCI_PREFIX, request.getInstanceId());
        return this.invokeHttpClient(internalRequest, GetInstanceResponse.class);
    }

    public ListInstancesResponse listInstances() throws BceClientException {
        return this.listInstances(new ListInstancesRequest());
    }

    public ListInstancesResponse listInstances(ListInstancesRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BCI_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (request.getKeywordType() != null) {
            internalRequest.addParameter(KEYWORD_TYPE, request.getKeywordType());
        }
        if (request.getKeyword() != null) {
            internalRequest.addParameter(KEYWORD, request.getKeyword());
        }
        return this.invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }
}

