/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.internal;

import com.baidubce.BceClientException;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.services.bos.model.BosProgressCallback;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;

public class RestartableResettableInputStream
extends RestartableInputStream {
    private InputStream input;

    public RestartableResettableInputStream(InputStream input) {
        Preconditions.checkNotNull((Object)input, (Object)"input should not be null.");
        Preconditions.checkArgument((boolean)input.markSupported(), (Object)"input does not support mark.");
        this.input = input;
    }

    public RestartableResettableInputStream(InputStream input, BosProgressCallback progressCallback) {
        this(input);
        super.setProgressCallback(progressCallback);
    }

    @Override
    public void restart() {
        try {
            this.input.reset();
            super.restartProgressCallback();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to reset the underlying input stream.", e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.input.read(b, off, len);
        if (count < 0) {
            return count;
        }
        super.doProgressCallback(count);
        return count;
    }

    @Override
    public int read() throws IOException {
        int count = this.input.read();
        if (count < 0) {
            return count;
        }
        super.doProgressCallback(1);
        return count;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

