/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.internal;

import com.baidubce.internal.RestartableInputStream;
import com.baidubce.services.bos.model.BosProgressCallback;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;

public class RestartableMultiByteArrayInputStream
extends RestartableInputStream {
    private List<byte[]> byteArrayList;
    private long pos = 0L;
    private int blockSize;
    private long length;

    public RestartableMultiByteArrayInputStream(List<byte[]> byteArrayList, long length) {
        Preconditions.checkNotNull(byteArrayList, (Object)"byteArrayList should not be null.");
        Preconditions.checkArgument((!byteArrayList.isEmpty() ? 1 : 0) != 0, (Object)"byteArrayList should not be empty.");
        long total = 0L;
        for (byte[] byteArray : byteArrayList) {
            Preconditions.checkNotNull((Object)byteArray, (Object)"byteArrayList should not contain null element.");
            Preconditions.checkArgument((byteArray.length > 0 ? 1 : 0) != 0, (Object)"byteArrayList should not contain empty byte array.");
            total += (long)byteArray.length;
        }
        Preconditions.checkArgument((total >= length ? 1 : 0) != 0, (String)"The specified length(%s) is greater than the total length(%s) of elements in byteArrayList.", (Object[])new Object[]{length, total});
        this.blockSize = byteArrayList.get(0).length;
        for (int i = 1; i < byteArrayList.size() - 1; ++i) {
            int len = byteArrayList.get(i).length;
            Preconditions.checkArgument((len == this.blockSize ? 1 : 0) != 0, (String)"All elements in byteArrayList except the last one should have the same length. The first element's length is %s but the %sth element's length is %s.", (Object[])new Object[]{this.blockSize, i, len});
        }
        this.byteArrayList = byteArrayList;
        this.length = length;
    }

    public RestartableMultiByteArrayInputStream(List<byte[]> byteArrayList, long length, BosProgressCallback progressCallback) {
        this(byteArrayList, length);
        super.setProgressCallback(progressCallback);
    }

    @Override
    public void restart() {
        this.pos = 0L;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull((Object)b, (Object)"b should not be null.");
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos == this.length) {
            return -1;
        }
        int count = 0;
        while (len > 0 && this.pos < this.length) {
            int index = (int)(this.pos / (long)this.blockSize);
            int offset = (int)(this.pos % (long)this.blockSize);
            byte[] byteArray = this.byteArrayList.get(index);
            int copyLength = byteArray.length - offset;
            if (copyLength > len) {
                copyLength = len;
            }
            System.arraycopy(byteArray, offset, b, off, copyLength);
            this.pos += (long)copyLength;
            off += copyLength;
            len -= copyLength;
            count += copyLength;
        }
        super.doProgressCallback(count);
        return count;
    }

    @Override
    public int read() {
        if (this.pos == this.length) {
            return -1;
        }
        int index = (int)(this.pos / (long)this.blockSize);
        int offset = (int)(this.pos % (long)this.blockSize);
        ++this.pos;
        super.doProgressCallback(1);
        return this.byteArrayList.get(index)[offset] & 0xFF;
    }
}

