/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.hbase;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendSession;
import com.baidu.hugegraph.backend.store.BackendSessionPool;
import com.baidu.hugegraph.backend.store.hbase.HbaseOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.StringEncoding;
import com.baidu.hugegraph.util.VersionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.VersionInfo;

public class HbaseSessions
extends BackendSessionPool {
    private final String namespace;
    private Connection hbase;

    public HbaseSessions(String namespace, String store) {
        super(namespace + "/" + store);
        this.namespace = namespace;
    }

    private Table table(String table) throws IOException {
        E.checkState((this.hbase != null ? 1 : 0) != 0, (String)"HBase connection is not opened", (Object[])new Object[0]);
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        return this.hbase.getTable(tableName);
    }

    public synchronized void open(HugeConfig conf) throws IOException {
        String hosts = (String)conf.get(HbaseOptions.HBASE_HOSTS);
        int port = (Integer)conf.get(HbaseOptions.HBASE_PORT);
        String znodeParent = (String)conf.get(HbaseOptions.HBASE_ZNODE_PARENT);
        Configuration config = HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", hosts);
        config.set("hbase.zookeeper.property.clientPort", String.valueOf(port));
        config.set("zookeeper.znode.parent", znodeParent);
        config.setInt("hbase.hconnection.threads.max", ((Integer)conf.get(HbaseOptions.HBASE_THREADS_MAX)).intValue());
        this.hbase = ConnectionFactory.createConnection((Configuration)config);
    }

    protected synchronized boolean opened() {
        return this.hbase != null && !this.hbase.isClosed();
    }

    public final Session session() {
        return (Session)super.getOrNewSession();
    }

    protected Session newSession() {
        return new Session();
    }

    protected synchronized void doClose() {
        if (this.hbase == null || this.hbase.isClosed()) {
            return;
        }
        try {
            this.hbase.close();
        }
        catch (IOException e) {
            throw new BackendException("Failed to close HBase connection", (Throwable)e);
        }
    }

    public boolean existsNamespace() throws IOException {
        try (Admin admin = this.hbase.getAdmin();){
            for (NamespaceDescriptor ns : admin.listNamespaceDescriptors()) {
                if (!this.namespace.equals(ns.getName())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void createNamespace() throws IOException {
        NamespaceDescriptor ns = NamespaceDescriptor.create((String)this.namespace).build();
        try (Admin admin = this.hbase.getAdmin();){
            admin.createNamespace(ns);
        }
    }

    public void dropNamespace() throws IOException {
        try (Admin admin = this.hbase.getAdmin();){
            admin.deleteNamespace(this.namespace);
        }
    }

    public boolean existsTable(String table) throws IOException {
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        try (Admin admin = this.hbase.getAdmin();){
            boolean bl = admin.tableExists(tableName);
            return bl;
        }
    }

    public void createTable(String table, List<byte[]> cfs) throws IOException {
        TableDescriptorBuilder tb = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.namespace, (String)table));
        for (byte[] cf : cfs) {
            tb.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf).build());
        }
        try (Admin admin = this.hbase.getAdmin();){
            admin.createTable(tb.build());
        }
    }

    public void dropTable(String table) throws IOException {
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        try (Admin admin = this.hbase.getAdmin();){
            try {
                admin.disableTable(tableName);
            }
            catch (TableNotEnabledException tableNotEnabledException) {
                // empty catch block
            }
            admin.deleteTable(tableName);
        }
    }

    public Future<Void> truncateTable(String table) throws IOException {
        assert (this.existsTable(table));
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        try (Admin admin = this.hbase.getAdmin();){
            try {
                admin.disableTable(tableName);
            }
            catch (TableNotEnabledException tableNotEnabledException) {
                // empty catch block
            }
            Future future = admin.truncateTableAsync(tableName, false);
            return future;
        }
    }

    public long storeSize(String table) throws IOException {
        long total = 0L;
        try (Admin admin = this.hbase.getAdmin();){
            for (ServerName rs : admin.getRegionServers()) {
                TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
                for (RegionMetrics m : admin.getRegionMetrics(rs, tableName)) {
                    total += m.getStoreFileSize().getLongValue();
                    total += m.getMemStoreSize().getLongValue();
                }
            }
        }
        return total;
    }

    protected static class RowIterator
    implements BackendEntry.BackendIterator<Result> {
        private final ResultScanner resultScanner;
        private final Iterator<Result> results;
        private byte[] position = null;

        public RowIterator(ResultScanner resultScanner) {
            this.resultScanner = resultScanner;
            this.results = resultScanner.iterator();
        }

        public RowIterator(Result ... results) {
            this.resultScanner = null;
            ArrayList<Result> rs = new ArrayList<Result>(results.length);
            for (Result result : results) {
                if (result.isEmpty()) continue;
                rs.add(result);
            }
            this.results = rs.iterator();
        }

        public boolean hasNext() {
            boolean has = this.results.hasNext();
            if (!has) {
                this.position = null;
                this.close();
            }
            return has;
        }

        public Result next() {
            this.position = null;
            Result next = this.results.next();
            this.position = next.getRow();
            return next;
        }

        public void close() {
            if (this.resultScanner != null) {
                this.resultScanner.close();
            }
        }

        public byte[] position() {
            return this.position;
        }
    }

    public final class Session
    extends BackendSession {
        private boolean closed = false;
        private final Map<String, List<Row>> batch = new HashMap<String, List<Row>>();

        private void batch(String table, Row row) {
            List<Row> rows = this.batch.get(table);
            if (rows == null) {
                rows = new ArrayList<Row>();
                this.batch.put(table, rows);
            }
            rows.add(row);
        }

        private int batchSize() {
            int size = 0;
            for (List<Row> puts : this.batch.values()) {
                size += puts.size();
            }
            return size;
        }

        public void close() {
            assert (this.closeable());
            this.closed = true;
        }

        public boolean closed() {
            return this.closed;
        }

        public boolean hasChanges() {
            return this.batch.size() > 0;
        }

        public Integer commit() {
            int count = this.batchSize();
            if (count <= 0) {
                return 0;
            }
            for (Map.Entry<String, List<Row>> action : this.batch.entrySet()) {
                List<Row> rows = action.getValue();
                Object[] results = new Object[rows.size()];
                try {
                    Table table = HbaseSessions.this.table(action.getKey());
                    Throwable throwable = null;
                    try {
                        table.batch(rows, results);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (table == null) continue;
                        if (throwable != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        table.close();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                    throw new BackendException((Throwable)e);
                }
            }
            this.batch.clear();
            return count;
        }

        public void rollback() {
            this.batch.clear();
        }

        public void put(String table, byte[] family, byte[] rowkey, Collection<BackendEntry.BackendColumn> columns) {
            Put put = new Put(rowkey);
            for (BackendEntry.BackendColumn column : columns) {
                put.addColumn(family, column.name, column.value);
            }
            this.batch(table, (Row)put);
        }

        public void put(String table, byte[] family, byte[] rowkey, byte[] qualifier, byte[] value) {
            Put put = new Put(rowkey);
            put.addColumn(family, qualifier, value);
            this.batch(table, (Row)put);
        }

        public void remove(String table, byte[] family, byte[] rowkey, byte[] qualifier) {
            this.remove(table, family, rowkey, qualifier, false);
        }

        public void remove(String table, byte[] family, byte[] rowkey, byte[] qualifier, boolean latestVersion) {
            assert (family != null);
            assert (rowkey != null);
            E.checkArgument((qualifier != null ? 1 : 0) != 0, (String)"HBase qualifier can't be null when removing", (Object[])new Object[0]);
            Delete delete = new Delete(rowkey);
            if (latestVersion) {
                delete.addColumn(family, qualifier);
            } else {
                delete.addColumns(family, qualifier);
            }
            this.batch(table, (Row)delete);
        }

        public void delete(String table, byte[] family, byte[] rowkey) {
            assert (rowkey != null);
            Delete delete = new Delete(rowkey);
            if (family != null) {
                delete.addFamily(family);
            }
            this.batch(table, (Row)delete);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RowIterator get(String table, byte[] family, byte[] rowkey, byte[] qualifier) {
            assert (!this.hasChanges());
            Get get = new Get(rowkey);
            get.addColumn(family, qualifier);
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.get(get));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RowIterator get(String table, byte[] family, byte[] rowkey) {
            assert (!this.hasChanges());
            Get get = new Get(rowkey);
            if (family != null) {
                get.addFamily(family);
            }
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.get(get));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RowIterator get(String table, byte[] family, Set<byte[]> rowkeys) {
            assert (!this.hasChanges());
            ArrayList<Get> gets = new ArrayList<Get>(rowkeys.size());
            for (byte[] rowkey : rowkeys) {
                Get get = new Get(rowkey);
                if (family != null) {
                    get.addFamily(family);
                }
                gets.add(get);
            }
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.get(gets));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        public RowIterator scan(String table, long limit) {
            assert (!this.hasChanges());
            Scan scan = new Scan();
            if (limit >= 0L) {
                scan.setFilter((Filter)new PageFilter(limit));
            }
            return this.scan(table, scan);
        }

        public RowIterator scan(String table, byte[] prefix) {
            assert (!this.hasChanges());
            return this.scan(table, prefix, true, prefix);
        }

        public RowIterator scan(String table, Set<byte[]> prefixs) {
            assert (!this.hasChanges());
            FilterList orFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            for (byte[] prefix : prefixs) {
                FilterList andFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
                ranges.add(new MultiRowRangeFilter.RowRange(prefix, true, null, true));
                andFilters.addFilter((Filter)new MultiRowRangeFilter(ranges));
                andFilters.addFilter((Filter)new PrefixFilter(prefix));
                orFilters.addFilter((Filter)andFilters);
            }
            Scan scan = new Scan().setFilter((Filter)orFilters);
            return this.scan(table, scan);
        }

        public RowIterator scan(String table, byte[] startRow, boolean inclusiveStart, byte[] prefix) {
            assert (!this.hasChanges());
            Scan scan = new Scan().withStartRow(startRow, inclusiveStart).setFilter((Filter)new PrefixFilter(prefix));
            return this.scan(table, scan);
        }

        public RowIterator scan(String table, byte[] startRow, byte[] stopRow) {
            assert (!this.hasChanges());
            return this.scan(table, startRow, true, stopRow, false);
        }

        public RowIterator scan(String table, byte[] startRow, boolean inclusiveStart, byte[] stopRow, boolean inclusiveStop) {
            assert (!this.hasChanges());
            Scan scan = new Scan().withStartRow(startRow, inclusiveStart);
            if (stopRow != null) {
                String version = VersionInfo.getVersion();
                if (inclusiveStop && !VersionUtil.gte((String)version, (String)"2.0")) {
                    inclusiveStop = false;
                    stopRow = Arrays.copyOf(stopRow, stopRow.length + 1);
                }
                if (Bytes.equals((byte[])startRow, (byte[])stopRow) && inclusiveStart && !inclusiveStop) {
                    return new RowIterator(new Result[0]);
                }
                scan.withStopRow(stopRow, inclusiveStop);
            }
            return this.scan(table, scan);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private RowIterator scan(String table, Scan scan) {
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.getScanner(scan));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long increase(String table, byte[] family, byte[] rowkey, byte[] qualifier, long value) {
            try (Table htable = HbaseSessions.this.table(table);){
                long l = htable.incrementColumnValue(rowkey, family, qualifier, value);
                return l;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        public long storeSize(String table) throws IOException {
            return HbaseSessions.this.storeSize(table);
        }

        private void dump(String table, Scan scan) throws IOException {
            System.out.println(String.format(">>>> scan table %s with %s", table, scan));
            RowIterator iterator = this.scan(table, scan);
            while (iterator.hasNext()) {
                Result row = iterator.next();
                System.out.println(StringEncoding.format((byte[])row.getRow()));
                CellScanner cellScanner = row.cellScanner();
                while (cellScanner.advance()) {
                    Cell cell = cellScanner.current();
                    byte[] key = CellUtil.cloneQualifier((Cell)cell);
                    byte[] val = CellUtil.cloneValue((Cell)cell);
                    System.out.println(String.format("  %s=%s", StringEncoding.format((byte[])key), StringEncoding.format((byte[])val)));
                }
            }
        }
    }
}

