/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.hbase;

import com.baidu.hugegraph.config.ConfigOption;
import com.baidu.hugegraph.config.OptionChecker;
import com.baidu.hugegraph.config.OptionHolder;

public class HbaseOptions
extends OptionHolder {
    private static volatile HbaseOptions instance;
    public static final ConfigOption<String> HBASE_HOSTS;
    public static final ConfigOption<Integer> HBASE_PORT;
    public static final ConfigOption<String> HBASE_ZNODE_PARENT;
    public static final ConfigOption<Integer> HBASE_THREADS_MAX;

    private HbaseOptions() {
    }

    public static synchronized HbaseOptions instance() {
        if (instance == null) {
            instance = new HbaseOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        HBASE_HOSTS = new ConfigOption("hbase.hosts", "The hostname or ip address of HBase zookeeper.", OptionChecker.disallowEmpty(), (Object)"localhost");
        HBASE_PORT = new ConfigOption("hbase.port", "The port address of HBase zookeeper.", OptionChecker.rangeInt((Number)1, (Number)65535), (Object)2181);
        HBASE_ZNODE_PARENT = new ConfigOption("hbase.znode_parent", "The znode parent path of HBase zookeeper.", OptionChecker.disallowEmpty(), (Object)"/hbase");
        HBASE_THREADS_MAX = new ConfigOption("hbase.threads_max", "The max threads num of hbase connections.", OptionChecker.rangeInt((Number)1, (Number)1000), (Object)64);
    }
}

