/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.hbase;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendAction;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendFeatures;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.BackendStoreProvider;
import com.baidu.hugegraph.backend.store.hbase.HbaseFeatures;
import com.baidu.hugegraph.backend.store.hbase.HbaseSessions;
import com.baidu.hugegraph.backend.store.hbase.HbaseTable;
import com.baidu.hugegraph.backend.store.hbase.HbaseTables;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.slf4j.Logger;

public abstract class HbaseStore
implements BackendStore {
    private static final Logger LOG = Log.logger(HbaseStore.class);
    private static final BackendFeatures FEATURES = new HbaseFeatures();
    private final String store;
    private final String namespace;
    private final BackendStoreProvider provider;
    private final Map<HugeType, HbaseTable> tables = new HashMap<HugeType, HbaseTable>();
    private final HbaseSessions sessions;

    public HbaseStore(BackendStoreProvider provider, String namespace, String store) {
        this.provider = provider;
        this.namespace = namespace;
        this.store = store;
        this.sessions = new HbaseSessions(namespace, store);
    }

    protected void registerTableManager(HugeType type, HbaseTable table) {
        this.tables.put(type, table);
    }

    protected final HbaseTable table(HugeType type) {
        assert (type != null);
        HbaseTable table = this.tables.get(type);
        if (table == null) {
            throw new BackendException("Unsupported table type: %s", new Object[]{type});
        }
        return table;
    }

    protected List<String> tableNames() {
        return this.tables.values().stream().map(t -> t.table()).collect(Collectors.toList());
    }

    public String namespace() {
        return this.namespace;
    }

    public String store() {
        return this.store;
    }

    public String database() {
        return this.namespace;
    }

    public BackendStoreProvider provider() {
        return this.provider;
    }

    public BackendFeatures features() {
        return FEATURES;
    }

    public void open(HugeConfig config) {
        E.checkNotNull((Object)config, (String)"config");
        if (this.sessions.opened()) {
            LOG.debug("Store {} has been opened before", (Object)this.store);
            this.sessions.useSession();
            return;
        }
        try {
            this.sessions.open(config);
        }
        catch (IOException e) {
            if (!e.getMessage().contains("Column family not found")) {
                LOG.error("Failed to open HBase '{}'", (Object)this.store, (Object)e);
                throw new BackendException("Failed to open HBase '%s'", (Throwable)e, new Object[]{this.store});
            }
            LOG.info("Failed to open HBase '{}' with database '{}', try to init CF later", (Object)this.store, (Object)this.namespace);
        }
        LOG.debug("Store opened: {}", (Object)this.store);
    }

    public void close() {
        this.checkOpened();
        this.sessions.close();
        LOG.debug("Store closed: {}", (Object)this.store);
    }

    public void mutate(BackendMutation mutation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Store {} mutation: {}", (Object)this.store, (Object)mutation);
        }
        this.checkOpened();
        HbaseSessions.Session session = this.sessions.session();
        Iterator it = mutation.mutation();
        while (it.hasNext()) {
            this.mutate(session, (BackendAction)it.next());
        }
    }

    private void mutate(HbaseSessions.Session session, BackendAction item) {
        BackendEntry entry = item.entry();
        HbaseTable table = this.table(entry.type());
        switch (item.action()) {
            case INSERT: {
                table.insert(session, entry);
                break;
            }
            case DELETE: {
                table.delete(session, entry);
                break;
            }
            case APPEND: {
                table.append(session, entry);
                break;
            }
            case ELIMINATE: {
                table.eliminate(session, entry);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported mutate action: %s", item.action()));
            }
        }
    }

    public Iterator<BackendEntry> query(Query query) {
        this.checkOpened();
        HbaseSessions.Session session = this.sessions.session();
        HbaseTable table = this.table(HbaseTable.tableType((Query)query));
        return table.query(session, query);
    }

    public void init() {
        this.checkOpened();
        try {
            this.sessions.createNamespace();
        }
        catch (NamespaceExistException namespaceExistException) {
        }
        catch (IOException e) {
            throw new BackendException("Failed to create namespace '%s' for '%s'", (Throwable)e, new Object[]{this.namespace, this.store});
        }
        for (String table : this.tableNames()) {
            try {
                this.sessions.createTable(table, HbaseTable.cfs());
            }
            catch (TableExistsException ignored) {
            }
            catch (IOException e) {
                throw new BackendException("Failed to create table '%s' for '%s'", (Throwable)e, new Object[]{table, this.store});
            }
        }
    }

    public void clear() {
        this.checkOpened();
        try {
            if (!this.sessions.existsNamespace()) {
                return;
            }
        }
        catch (IOException e) {
            throw new BackendException("Exception when checking for the existence of '%s'", (Throwable)e, new Object[]{this.namespace});
        }
        for (String table : this.tableNames()) {
            try {
                this.sessions.dropTable(table);
            }
            catch (TableNotFoundException e) {
            }
            catch (IOException e) {
                throw new BackendException("Failed to drop table '%s' for '%s'", (Throwable)e, new Object[]{table, this.store});
            }
        }
        try {
            this.sessions.dropNamespace();
        }
        catch (IOException e) {
            String notEmpty = "Only empty namespaces can be removed";
            if (e.getCause().getMessage().contains(notEmpty)) {
                LOG.debug("Can't drop namespace '{}': {}", (Object)this.namespace, (Object)e);
            }
            throw new BackendException("Failed to drop namespace '%s' for '%s'", (Throwable)e, new Object[]{this.namespace, this.store});
        }
    }

    public void beginTx() {
    }

    public void commitTx() {
        this.checkOpened();
        HbaseSessions.Session session = this.sessions.session();
        try {
            session.commit();
        }
        finally {
            session.clear();
        }
    }

    public void rollbackTx() {
    }

    public <R> R metadata(HugeType type, String meta, Object[] args) {
        this.checkOpened();
        HbaseSessions.Session session = this.sessions.session();
        HbaseTable table = this.table(type);
        return (R)table.metadata(session, meta, args);
    }

    private void checkOpened() {
        E.checkState((this.sessions != null ? 1 : 0) != 0, (String)"HBase store has not been initialized", (Object[])new Object[0]);
    }

    public static class HbaseGraphStore
    extends HbaseStore {
        public HbaseGraphStore(BackendStoreProvider provider, String namespace, String store) {
            super(provider, namespace, store);
            this.registerTableManager(HugeType.VERTEX, new HbaseTables.Vertex(store));
            this.registerTableManager(HugeType.EDGE_OUT, HbaseTables.Edge.out(store));
            this.registerTableManager(HugeType.EDGE_IN, HbaseTables.Edge.in(store));
            this.registerTableManager(HugeType.SECONDARY_INDEX, new HbaseTables.SecondaryIndex(store));
            this.registerTableManager(HugeType.RANGE_INDEX, new HbaseTables.RangeIndex(store));
            this.registerTableManager(HugeType.SEARCH_INDEX, new HbaseTables.SearchIndex(store));
        }

        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("HbaseGraphStore.nextId()");
        }
    }

    public static class HbaseSchemaStore
    extends HbaseStore {
        private final HbaseTables.Counters counters = new HbaseTables.Counters();

        public HbaseSchemaStore(BackendStoreProvider provider, String namespace, String store) {
            super(provider, namespace, store);
            this.registerTableManager(HugeType.VERTEX_LABEL, new HbaseTables.VertexLabel());
            this.registerTableManager(HugeType.EDGE_LABEL, new HbaseTables.EdgeLabel());
            this.registerTableManager(HugeType.PROPERTY_KEY, new HbaseTables.PropertyKey());
            this.registerTableManager(HugeType.INDEX_LABEL, new HbaseTables.IndexLabel());
            this.registerTableManager(HugeType.SECONDARY_INDEX, new HbaseTables.SecondaryIndex(store));
        }

        @Override
        protected List<String> tableNames() {
            List<String> tableNames = super.tableNames();
            tableNames.add(this.counters.table());
            return tableNames;
        }

        public Id nextId(HugeType type) {
            ((HbaseStore)this).checkOpened();
            return this.counters.nextId(((HbaseStore)this).sessions.session(), type);
        }
    }
}

