/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.easydl;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import org.json.JSONObject;

public class AipEasyDL
extends BaseClient {
    public AipEasyDL(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject sendImageRequest(String url, String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.sendImageRequest(url, data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject sendImageRequest(String url, byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String content = Base64Util.encode(image);
        request.addBody("image", content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(url);
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sendSoundRequest(String url, String file, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(file);
            return this.sendSoundRequest(url, data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject sendSoundRequest(String url, byte[] data, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String content = Base64Util.encode(data);
        request.addBody("sound", content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(url);
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }
}

