/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.implementation.listener.adapter;

import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.implementation.listener.ListenerExecutionFailedException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public abstract class MessagingMessageListenerAdapter {
    @Nullable
    private InvocableHandlerMethod handlerMethod;
    protected Class<?> payloadType = byte[].class;
    protected AzureMessageConverter<?, ?> messageConverter;

    protected void invokeHandler(Message<?> message) {
        InvocableHandlerMethod validHandlerMethod = this.getHandlerMethod();
        try {
            validHandlerMethod.invoke(message, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new ListenerExecutionFailedException(ex.getMessage(), ex);
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with incoming message"), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + validHandlerMethod.getMethod().toGenericString() + "' threw exception", ex);
        }
    }

    protected final String createMessagingErrorMessage(String description) {
        InvocableHandlerMethod validHandlerMethod = this.getHandlerMethod();
        return description + "\nEndpoint handler details:\nMethod [" + validHandlerMethod.getMethod().toGenericString() + "]\nBean [" + validHandlerMethod.getBean() + "]\n";
    }

    private Class<?> resolveMessagePayloadType(InvocableHandlerMethod method) {
        Object[] parameterTypes = method.getMethod().getParameterTypes();
        Assert.notEmpty((Object[])parameterTypes, (String)"Azure message handler method should not have empty parameters");
        return parameterTypes[0];
    }

    public AzureMessageConverter<?, ?> getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(AzureMessageConverter<?, ?> messageConverter) {
        this.messageConverter = messageConverter;
    }

    public InvocableHandlerMethod getHandlerMethod() {
        Assert.state((this.handlerMethod != null ? 1 : 0) != 0, (String)"No HandlerMethod set");
        return this.handlerMethod;
    }

    public void setHandlerMethod(InvocableHandlerMethod handlerMethod) {
        this.handlerMethod = handlerMethod;
        this.payloadType = this.resolveMessagePayloadType(handlerMethod);
    }

    public void setPayloadType(Class<?> payloadType) {
        this.payloadType = payloadType;
    }

    public Class<?> getPayloadType() {
        return this.payloadType;
    }
}

