/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.implementation.core.annotation;

import com.azure.spring.messaging.implementation.annotation.AzureListenerAnnotationBeanPostProcessorAdapter;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpoint;
import com.azure.spring.messaging.servicebus.implementation.core.annotation.ServiceBusListener;
import com.azure.spring.messaging.servicebus.implementation.core.annotation.ServiceBusListeners;
import com.azure.spring.messaging.servicebus.implementation.core.config.MethodServiceBusListenerEndpoint;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.StringUtils;

public class ServiceBusListenerAnnotationBeanPostProcessor
extends AzureListenerAnnotationBeanPostProcessorAdapter<ServiceBusListener> {
    public static final String DEFAULT_SERVICE_BUS_LISTENER_ANNOTATION_BPP_BEAN_NAME = "serviceBusListenerAnnotationBeanPostProcessor";
    private static final String DEFAULT_SERVICE_BUS_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "azureServiceBusListenerContainerFactory";

    public ServiceBusListenerAnnotationBeanPostProcessor() {
        this.containerFactoryBeanName = DEFAULT_SERVICE_BUS_LISTENER_CONTAINER_FACTORY_BEAN_NAME;
    }

    protected Set<ServiceBusListener> findListenerMethods(Method method) {
        return AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, this.getListenerType(), ServiceBusListeners.class);
    }

    protected AzureListenerEndpoint createAndConfigureMethodListenerEndpoint(ServiceBusListener listenerAnnotation, Object bean, Method method, BeanFactory beanFactory, MessageHandlerMethodFactory messageHandlerMethodFactory) {
        MethodServiceBusListenerEndpoint endpoint = new MethodServiceBusListenerEndpoint();
        endpoint.setBean(bean);
        endpoint.setMethod(method);
        endpoint.setBeanFactory(beanFactory);
        endpoint.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(listenerAnnotation));
        endpoint.setDestination(this.resolve(listenerAnnotation.destination()));
        if (StringUtils.hasText((String)listenerAnnotation.group())) {
            endpoint.setGroup(this.resolve(listenerAnnotation.group()));
        }
        if (StringUtils.hasText((String)listenerAnnotation.concurrency())) {
            endpoint.setConcurrency(this.resolve(listenerAnnotation.concurrency()));
        }
        return endpoint;
    }

    protected String getEndpointId(ServiceBusListener listenerAnnotation) {
        if (StringUtils.hasText((String)listenerAnnotation.id())) {
            String id = this.resolve(listenerAnnotation.id());
            return id != null ? id : "";
        }
        return "org.springframework.azure.ServiceBusListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    protected String getContainerFactoryBeanName(ServiceBusListener listenerAnnotation) {
        return listenerAnnotation.containerFactory();
    }

    protected Class<ServiceBusListener> getListenerType() {
        return ServiceBusListener.class;
    }

    public String getDefaultAzureListenerAnnotationBeanPostProcessorBeanName() {
        return DEFAULT_SERVICE_BUS_LISTENER_ANNOTATION_BPP_BEAN_NAME;
    }
}

