/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.support.converter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.spring.messaging.converter.AbstractAzureMessageConverter;
import com.azure.spring.messaging.implementation.converter.ObjectMapperHolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;

public class EventHubsMessageConverter
extends AbstractAzureMessageConverter<EventData, EventData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubsMessageConverter.class);
    static final String TARGET_PROTOCOL = "target-protocol";
    private static final Set<String> IGNORED_SPRING_MESSAGE_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("azure_partition_key", "azure_batch_converted_partition_key", "azure_eventhubs_enqueued_time", "azure_eventhubs_batch_converted_enqueued_time", "azure_eventhubs_offset", "azure_eventhubs_batch_converted_offset", "azure_eventhubs_sequence_number", "azure_eventhubs_batch_converted_sequence_number", "azure_eventhubs_batch_converted_system_properties", "azure_eventhubs_batch_converted_application_properties")));
    private final ObjectMapper objectMapper;

    public EventHubsMessageConverter() {
        this(ObjectMapperHolder.OBJECT_MAPPER);
    }

    public EventHubsMessageConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected byte[] getPayload(EventData azureMessage) {
        return azureMessage.getBody();
    }

    protected EventData fromString(String payload) {
        return new EventData(payload.getBytes(StandardCharsets.UTF_8));
    }

    protected EventData fromByte(byte[] payload) {
        return new EventData(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, EventData azureMessage) {
        super.setCustomHeaders(headers, (Object)azureMessage);
        HashSet ignoredHeaders = new HashSet();
        headers.forEach((key, value) -> {
            if (IGNORED_SPRING_MESSAGE_HEADERS.contains(key)) {
                ignoredHeaders.add(key);
            } else {
                azureMessage.getProperties().put(key, value.toString());
            }
        });
        if (azureMessage.getProperties().containsKey(TARGET_PROTOCOL)) {
            azureMessage.getProperties().put(TARGET_PROTOCOL, "amqp");
        }
        ignoredHeaders.forEach(header -> LOGGER.info("Message headers {} is not supported to be set and will be ignored.", header));
    }

    protected Map<String, Object> buildCustomHeaders(EventData azureMessage) {
        Map headers = super.buildCustomHeaders((Object)azureMessage);
        headers.putAll(this.getSystemProperties(azureMessage));
        headers.putAll(azureMessage.getProperties());
        return headers;
    }

    private Map<String, Object> getSystemProperties(EventData azureMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>(azureMessage.getSystemProperties());
        result.put("azure_eventhubs_enqueued_time", azureMessage.getEnqueuedTime());
        result.put("azure_eventhubs_offset", azureMessage.getOffset());
        result.put("azure_eventhubs_sequence_number", azureMessage.getSequenceNumber());
        result.put("azure_partition_key", azureMessage.getPartitionKey());
        return result;
    }
}

