/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.support.converter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventBatchContext;
import com.azure.spring.messaging.converter.AbstractAzureMessageConverter;
import com.azure.spring.messaging.implementation.converter.ObjectMapperHolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class EventHubsBatchMessageConverter
extends AbstractAzureMessageConverter<EventBatchContext, EventData> {
    private final ObjectMapper objectMapper;

    public EventHubsBatchMessageConverter() {
        this(ObjectMapperHolder.OBJECT_MAPPER);
    }

    public EventHubsBatchMessageConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected EventData fromString(String payload) {
        throw new UnsupportedOperationException();
    }

    protected EventData fromByte(byte[] payload) {
        throw new UnsupportedOperationException();
    }

    protected void setCustomHeaders(MessageHeaders headers, EventData azureMessage) {
        throw new UnsupportedOperationException();
    }

    protected Object getPayload(EventBatchContext azureMessage) {
        return azureMessage.getEvents().stream().map(EventData::getBody).collect(Collectors.toList());
    }

    protected <U> Message<?> internalToMessage(EventBatchContext azureMessage, Map<String, Object> headers, Class<U> targetPayloadClass) {
        List payload = (List)this.getPayload(azureMessage);
        Assert.isTrue((payload != null ? 1 : 0) != 0, (String)"payload must not be null");
        if (targetPayloadClass.isInstance(azureMessage)) {
            return MessageBuilder.withPayload((Object)azureMessage).copyHeaders(headers).build();
        }
        if (targetPayloadClass == String.class) {
            List payLoadList = payload.stream().map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(Collectors.toList());
            return MessageBuilder.withPayload(payLoadList).copyHeaders(headers).build();
        }
        if (targetPayloadClass == byte[].class) {
            return MessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
        }
        List payLoadList = payload.stream().map(bytes -> this.fromPayload(bytes, targetPayloadClass)).collect(Collectors.toList());
        return MessageBuilder.withPayload(payLoadList).copyHeaders(headers).build();
    }

    protected Map<String, Object> buildCustomHeaders(EventBatchContext azureMessage) {
        Map headers = super.buildCustomHeaders((Object)azureMessage);
        List events = azureMessage.getEvents();
        ArrayList<Instant> enqueueTimeList = new ArrayList<Instant>();
        ArrayList<Long> offSetList = new ArrayList<Long>();
        ArrayList<Long> sequenceNumberList = new ArrayList<Long>();
        ArrayList<String> partitionKeyList = new ArrayList<String>();
        ArrayList<Map> batchConvertedSystemProperties = new ArrayList<Map>();
        ArrayList<Map> batchConvertedApplicationProperties = new ArrayList<Map>();
        for (EventData event : events) {
            enqueueTimeList.add(event.getEnqueuedTime());
            offSetList.add(event.getOffset());
            sequenceNumberList.add(event.getSequenceNumber());
            partitionKeyList.add(event.getPartitionKey());
            batchConvertedSystemProperties.add(event.getSystemProperties());
            batchConvertedApplicationProperties.add(event.getProperties());
        }
        headers.put("azure_eventhubs_batch_converted_enqueued_time", enqueueTimeList);
        headers.put("azure_eventhubs_batch_converted_offset", offSetList);
        headers.put("azure_eventhubs_batch_converted_sequence_number", sequenceNumberList);
        headers.put("azure_batch_converted_partition_key", partitionKeyList);
        headers.put("azure_eventhubs_batch_converted_system_properties", batchConvertedSystemProperties);
        headers.put("azure_eventhubs_batch_converted_application_properties", batchConvertedApplicationProperties);
        return headers;
    }
}

