/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.core.annotation;

import com.azure.spring.messaging.eventhubs.implementation.core.annotation.EventHubsListener;
import com.azure.spring.messaging.eventhubs.implementation.core.annotation.EventHubsListeners;
import com.azure.spring.messaging.eventhubs.implementation.core.config.MethodEventHubsListenerEndpoint;
import com.azure.spring.messaging.implementation.annotation.AzureListenerAnnotationBeanPostProcessorAdapter;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpoint;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.StringUtils;

public class EventHubsListenerAnnotationBeanPostProcessor
extends AzureListenerAnnotationBeanPostProcessorAdapter<EventHubsListener> {
    public static final String DEFAULT_EVENT_HUBS_LISTENER_ANNOTATION_BPP_BEAN_NAME = "eventHubsListenerAnnotationBeanPostProcessor";
    private static final String DEFAULT_EVENT_HUBS_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "azureEventHubsListenerContainerFactory";

    public EventHubsListenerAnnotationBeanPostProcessor() {
        this.containerFactoryBeanName = DEFAULT_EVENT_HUBS_LISTENER_CONTAINER_FACTORY_BEAN_NAME;
    }

    protected Set<EventHubsListener> findListenerMethods(Method method) {
        return AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, this.getListenerType(), EventHubsListeners.class);
    }

    protected AzureListenerEndpoint createAndConfigureMethodListenerEndpoint(EventHubsListener listenerAnnotation, Object bean, Method method, BeanFactory beanFactory, MessageHandlerMethodFactory messageHandlerMethodFactory) {
        MethodEventHubsListenerEndpoint endpoint = new MethodEventHubsListenerEndpoint();
        endpoint.setBean(bean);
        endpoint.setMethod(method);
        endpoint.setBeanFactory(beanFactory);
        endpoint.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(listenerAnnotation));
        endpoint.setDestination(this.resolve(listenerAnnotation.destination()));
        if (StringUtils.hasText((String)listenerAnnotation.group())) {
            endpoint.setGroup(this.resolve(listenerAnnotation.group()));
        }
        if (StringUtils.hasText((String)listenerAnnotation.concurrency())) {
            endpoint.setConcurrency(this.resolve(listenerAnnotation.concurrency()));
        }
        endpoint.setBatchListener(false);
        return endpoint;
    }

    protected String getEndpointId(EventHubsListener listenerAnnotation) {
        if (StringUtils.hasText((String)listenerAnnotation.id())) {
            String id = this.resolve(listenerAnnotation.id());
            return id != null ? id : "";
        }
        return "org.springframework.azure.EventHubsListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    protected String getContainerFactoryBeanName(EventHubsListener listenerAnnotation) {
        return listenerAnnotation.containerFactory();
    }

    protected Class<EventHubsListener> getListenerType() {
        return EventHubsListener.class;
    }

    public String getDefaultAzureListenerAnnotationBeanPostProcessorBeanName() {
        return DEFAULT_EVENT_HUBS_LISTENER_ANNOTATION_BPP_BEAN_NAME;
    }
}

